//+------------------------------------------------------------------+
//|                                                       PVT_v1.mq4 |
//|                           Copyright  2006, TrendLaboratory Ltd. |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                       E-mail: igorad2004@list.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, TrendLaboratory Ltd."
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 DodgerBlue
//---- input parameters
extern int Price     =0;
extern int BarsBack  =1;
//---- buffers
double PVT[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
//---- indicator buffer mapping
   SetIndexBuffer(0,PVT);
//---- indicator line
   SetIndexStyle(0,DRAW_LINE);
//---- name for DataWindow and indicator subwindow label
   string short_name="PVT("+Price+","+BarsBack+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,"PVT");
   SetIndexDrawBegin(0,BarsBack);
//----
   return(0);
}
//+------------------------------------------------------------------+
//| Price and Volume Trend                                           |
//+------------------------------------------------------------------+
int start()
{
   int   i,limit,counted_bars=IndicatorCounted();
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   if(counted_bars==0) limit=Bars-BarsBack;
   limit=Bars-counted_bars+BarsBack;
//---- 
   for(i=limit; i>=0; i--)
   {
      if(i==Bars-BarsBack) PVT[i]=Volume[i];
      else
      {
      double CurPrice  = iMA(NULL,0,1,0,0,Price,i);
      double PrevPrice = iMA(NULL,0,1,0,0,Price,i+BarsBack);
      
      if(PrevPrice>0)
      PVT[i] = Volume[i]*(CurPrice-PrevPrice)/PrevPrice + PVT[i+1]; 
      }
   }
//----
   return(0);
}

