//+------------------------------------------------------------------+
//|                                               PairDifference.mq4 |
//|                                                                  |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Created by RoBiK"
#property link      ""

#property indicator_separate_window
#property indicator_buffers 8
#property indicator_color1 Red
#property indicator_color2 Green
#property indicator_color3 Blue
#property indicator_color4 White
#property indicator_color5 Yellow
#property indicator_color6 Purple
#property indicator_color7 Gray
#property indicator_color8 Olive
//---- input parameters
extern int       NeutralPeriod = 48;
extern int       MaxPeriod = 960;
extern int       MAPeriod = 12;
extern int       MAMethod = MODE_EMA;
extern int       MAPrice = PRICE_CLOSE;
extern string    Pair1 = "EURUSD";
extern bool      Inverted1 = false;
extern string    Pair2;
extern bool      Inverted2 = false;
extern string    Pair3;
extern bool      Inverted3 = false;
extern string    Pair4;
extern bool      Inverted4 = false;
extern string    Pair5;
extern bool      Inverted5 = false;
extern string    Pair6;
extern bool      Inverted6 = false;
extern string    Pair7;
extern bool      Inverted7 = false;
extern string    Pair8;
extern bool      Inverted8 = false;
//---- buffers
double b1[];
double b2[];
double b3[];
double b4[];
double b5[];
double b6[];
double b7[];
double b8[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   IndicatorShortName("PD");
   if (StringLen(Pair1) > 0)
   {
     SetIndexStyle(0,DRAW_LINE);
     SetIndexBuffer(0,b1);
     SetIndexDrawBegin(0, Bars - MaxPeriod);
     SetIndexLabel(0, Pair1);
   }
   else SetIndexStyle(0,DRAW_NONE);
   if (StringLen(Pair2) > 0)
   {
     SetIndexStyle(1,DRAW_LINE);
     SetIndexBuffer(1,b2);
     SetIndexDrawBegin(1, Bars - MaxPeriod);
     SetIndexLabel(1, Pair2);
   }
   else SetIndexStyle(1,DRAW_NONE);
   if (StringLen(Pair3) > 0)
   {
     SetIndexStyle(2,DRAW_LINE);
     SetIndexBuffer(2,b3);
     SetIndexDrawBegin(2, Bars - MaxPeriod);
     SetIndexLabel(2, Pair3);
   }
   else SetIndexStyle(2,DRAW_NONE);
   if (StringLen(Pair4) > 0)
   {
     SetIndexStyle(3,DRAW_LINE);
     SetIndexBuffer(3,b4);
     SetIndexDrawBegin(3, Bars - MaxPeriod);
     SetIndexLabel(3, Pair4);
   }
   else SetIndexStyle(3,DRAW_NONE);
   if (StringLen(Pair5) > 0)
   {
     SetIndexStyle(4,DRAW_LINE);
     SetIndexBuffer(4,b5);
     SetIndexDrawBegin(4, Bars - MaxPeriod);
     SetIndexLabel(4, Pair5);
   }
   else SetIndexStyle(4,DRAW_NONE);
   if (StringLen(Pair6) > 0)
   {
     SetIndexStyle(5,DRAW_LINE);
     SetIndexBuffer(5,b6);
     SetIndexDrawBegin(5, Bars - MaxPeriod);
     SetIndexLabel(5, Pair6);
   }
   else SetIndexStyle(5,DRAW_NONE);
   if (StringLen(Pair7) > 0)
   {
     SetIndexStyle(6,DRAW_LINE);
     SetIndexBuffer(6,b7);
     SetIndexDrawBegin(6, Bars - MaxPeriod);
     SetIndexLabel(6, Pair7);
   }
   else SetIndexStyle(6,DRAW_NONE);
   if (StringLen(Pair8) > 0)
   {
     SetIndexStyle(7,DRAW_LINE);
     SetIndexBuffer(7,b8);
     SetIndexDrawBegin(7, Bars - MaxPeriod);
     SetIndexLabel(7, Pair8);
   }
   else SetIndexStyle(7,DRAW_NONE);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   if (Bars < MaxPeriod) return(0);
//----
   for (int i = 0; i < MaxPeriod; i++)
   {
     double c = Coeficient(NULL, false, i);
     if (StringLen(Pair1) > 0) b1[i] = Coeficient(Pair1, Inverted1, i) - c;
     if (StringLen(Pair2) > 0) b2[i] = Coeficient(Pair2, Inverted2, i) - c;
     if (StringLen(Pair3) > 0) b3[i] = Coeficient(Pair3, Inverted3, i) - c;
     if (StringLen(Pair4) > 0) b4[i] = Coeficient(Pair4, Inverted4, i) - c;
     if (StringLen(Pair5) > 0) b5[i] = Coeficient(Pair5, Inverted5, i) - c;
     if (StringLen(Pair6) > 0) b6[i] = Coeficient(Pair6, Inverted6, i) - c;
     if (StringLen(Pair7) > 0) b7[i] = Coeficient(Pair7, Inverted7, i) - c;
     if (StringLen(Pair8) > 0) b8[i] = Coeficient(Pair8, Inverted8, i) - c;
   }
//----
   return(0);
  }
//+------------------------------------------------------------------+

double Coeficient(string pair, bool inverted, int shift)
{
   double c1, c2;
   c1 = iMA(pair, 0, MAPeriod, shift, MAMethod, MAPrice, 0);
   c2 = iMA(pair, 0, MAPeriod, NeutralPeriod, MAMethod, MAPrice, 0);
   if (c1 == c2) return(0);
   if (inverted)
   {
     c1 = 1 / c1;
     c2 = 1 / c2;
   }
   return (100 * (c1 - c2)/ c2);
}