//+------------------------------------------------------------------+
//|                                                    PhatCCIca.mq4 |
//|                                                   Lowphat  2005 |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Lowphat  2005"
#property link      "http://www.metaquotes.net"

#property indicator_separate_window
#property indicator_maximum 200
#property indicator_minimum -200
#property indicator_buffers 8
#property indicator_color1 Magenta
#property indicator_color2 Lime
#property indicator_color3 Red
#property indicator_color4 Aqua
#property indicator_color5 Yellow
#property indicator_color6 Gray
#property indicator_color7 Gray
#property indicator_color8 Gray

extern int TimeFrame = 0;
extern int MainPer = 50;
extern int per1 = 4;
extern int per2 = 20;
extern int BandPer = 10;
extern double BandDev = 2;


#property indicator_level2 100
#property indicator_level3 -100


double main[];
double cciHup[];
double cciHdn[];
double phat1[];
double phat2[];
double phat3[];
double ibandp[];
double iband[];
double iband2[];


int init()
  {
   SetIndexStyle(0,DRAW_LINE,0,1);
   SetIndexBuffer(0,main);
   SetIndexStyle(1,DRAW_HISTOGRAM,0,1);
   SetIndexBuffer(1,cciHup);
   SetIndexStyle(2,DRAW_HISTOGRAM,0,1);
   SetIndexBuffer(2,cciHdn);
   SetIndexStyle(3,DRAW_LINE,0,1);
   SetIndexBuffer(3,phat1);
   SetIndexStyle(4,DRAW_LINE,0,1);
   SetIndexBuffer(4,phat2);
   SetIndexStyle(5,DRAW_LINE,2);
   SetIndexBuffer(5,ibandp);
   SetIndexStyle(6,DRAW_LINE);
   SetIndexBuffer(6,iband);       
   SetIndexStyle(7,DRAW_LINE);
   SetIndexBuffer(7,iband2);  
   //IndicatorShortName("CCI Period ("+MainPer+")  Average1 ("+per1+")  Average2 ("+per2+")  Band Period ("+BandPer+")  Band Deviation ("+BandDev+")");  
IndicatorShortName("AC");
   return(0);
  }

int deinit()
  {

   return(0);
  }

int start()
  {
 datetime TimeArray[];
   int    y,limit,i=0,counted_bars=IndicatorCounted();
   
    // int i,limit;
    // int counted_bars=IndicatorCounted();
     if(counted_bars>0) counted_bars--;
     
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame); 
   
     limit=Bars-counted_bars;
     for(y=0,i=0;i<limit;y++)
   {
   if (Time[y]<TimeArray[i]) i++;
             
     main[i]=iCCI(NULL,TimeFrame,MainPer,PRICE_CLOSE,i);
  
      if (main[i] >= 0 )
     cciHup[i] = main[i];
      else
     cciHup[i] = 0;
      if (main[i] < 0 )
     cciHdn[i] = main[i];
      else
     cciHdn[i]=0; 
      }
      
      
        for(y=0,i=0;i<limit;y++)
   {
   if (Time[y]<TimeArray[i]) i++;
     phat1[i]=iMAOnArray(main,Bars,per1,0,MODE_EMA,i);
     }
     
        for(y=0,i=0;i<limit;y++)
   {
   if (Time[y]<TimeArray[i]) i++;
     phat2[i]=iMAOnArray(main,Bars,per2,0,MODE_EMA,i);
     }

        for(y=0,i=0;i<limit;y++)
   {
   if (Time[y]<TimeArray[i]) i++;
   }
     iband[i]=iBandsOnArray(main,0,BandPer,BandDev,0,MODE_UPPER,i);
        for(y=0,i=0;i<limit;y++)
   {
   if (Time[y]<TimeArray[i]) i++;  
     iband2[i]=iBandsOnArray(main,0,BandPer,BandDev,0,MODE_LOWER,i);
 }
   return(0);
  }

