//+------------------------------------------------------------------+
//|                                                    PivotPtMA.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_color2 Yellow

double pivot1[];
double curAvg[];



void init()
  {
  
         SetIndexBuffer(0, pivot1);
         SetIndexStyle(0,DRAW_LINE);
         
         
         
         SetIndexBuffer(1, curAvg);
         SetIndexStyle(1,DRAW_LINE);
         return(0);

  }
  
  int deinit()
  {
//----
   return(0);
  }





void start()
  {
         
         int counted = IndicatorCounted();
         
         if(counted < 0) return (-1);
         
         if (counted > 0) counted --;
         
         int limit = Bars - counted; 
         //int x = 6;
         //int y = x / 2;
         //Print("y = ", y);
  
         
         for (int i = 0; i < limit; i++)
         {
              
              double h1 = High[i];
              double h2 = High[i+2];
              double h3 = High[i+3];
              double h4 = High[i+4];
              double h5 = High[i+5];
             
        
              double l1 = Low[i];
              double l2 = Low[i+2];
              double l3 = Low[i+3];
              double l4 = Low[i+4];
              double l5 = Low[i+5];
             
        
              double c1 = Close[i];
              double c2 = Close[i+2];
              double c3 = Close[i+3];
              double c4 = Close[i+4];
              double c5 = Close[i+5];
              

              double piv1 = h1 + l1 + c1;
              piv1 = piv1 / 3.0000;

              pivot1[i] = NormalizeDouble(piv1, 4);
              
              double pivot2 = h2 + l2 + c2;
              pivot2 = pivot2 / 3.0000;
              double pivot3 = h3 + l3 + c3;
              pivot3 = pivot3 / 3.0000;
              double pivot4 = h4 + l4 + c4;
              pivot4 = pivot4 / 3.0000;
              double pivot5 = h5 + l5 + c5;
              pivot5 = pivot5 / 3.0000;
              
              double tempAvg;
              
              tempAvg = piv1 + pivot2 + pivot3 + pivot4 + pivot5;
              tempAvg = tempAvg / 5.0000;
                   
              curAvg[i] = NormalizeDouble(tempAvg, 4);
            
         }
         
         return(0);

        
  }

