//+------------------------------------------------------------------+
//|                                              Price Predictor.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
#include <WinUser32.mqh>
extern bool IsMini= false;
extern bool UseBid= true;
string pairs[14][3]={
"EURJPY","EURAUD","AUDJPY",//1 d
"EURJPY","EURCHF","CHFJPY",//6 h, inv
"EURJPY","EURGBP","GBPJPY",//12 inv
"EURJPY","EURUSD","USDJPY",//14
"AUDJPY","AUDUSD","USDJPY",//2 d
"EURUSD","EURAUD","AUDUSD",//3 d
"EURUSD","EURGBP","GBPUSD",//13
"USDJPY","USDCHF","CHFJPY",//8 
"GBPJPY","GBPCHF","CHFJPY",//7 inv
"GBPJPY","GBPUSD","USDJPY",//14
"EURCAD","EURUSD","USDCAD",//9 inv
"EURCHF","EURGBP","GBPCHF",//10 inv
"EURCHF","EURUSD","USDCHF",//11 inv
"GBPCHF","GBPUSD","USDCHF",//15
};
int match[];
int itn;string cal[14];
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
   if(IsMini){
      for(int i=0;i<14;i++){
         for(int y=0;y<3;y++){
            pairs[i][y]=pairs[i][y]+"m";
         }
      }
   }
   int c;
   for( i=0;i<14;i++){
      for( y=0;y<3;y++){
         if(pairs[i][y]==Symbol()){
            string ord="";
            for(int h=0;h<3;h++){
               ord=ord+pairs[i][h]+" ";
            }
            if(MessageBox(ord,"Would you like track this RING?", MB_YESNO | MB_ICONQUESTION)==6){
               c++;
               ArrayResize(match,c);
               match[c-1]=i;
            }
         }
      }
   }
   start();
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
  {
//----
   while(true){
      RefreshRates();
      main();
      itn++;
      Sleep(100);
   }
//----
   return(0);
  }
  
  
//+------------------------------------------------------------------+

void main(){
   color col[]={Yellow,Orange,Pink,YellowGreen,Purple,Red};
   string colst[]={"Yellow","Orange","Pink","YellowGreen","Purple","Red"};
   
   int c=0;
   
   int size=ArraySize(match);
   /*for(i=0;i<size;i++){
      Comment("ring found ",match[i],"\n\n",
      pairs[match[i]][0],"  ",
      pairs[match[i]][1],"  ",
      pairs[match[i]][2],"  ");
      Sleep(2000);
   }
      */
   //Comment("\nMatches = ",size,"\nIterations = ",itn);
   static double fpi[];
   ////////////////////
   getFPI(match,fpi);////////////////
   ////////////////////
   for(int i=0;i<size;i++){
      double level=0;
      if(UseBid)double pr1=MarketInfo(pairs[match[i]][0],MODE_BID);else pr1= MarketInfo(pairs[match[i]][0],MODE_ASK);
      if(UseBid)double pr2=MarketInfo(pairs[match[i]][1],MODE_BID);else pr2= MarketInfo(pairs[match[i]][1],MODE_ASK);
      if(UseBid)double pr3=MarketInfo(pairs[match[i]][2],MODE_BID);else pr3= MarketInfo(pairs[match[i]][2],MODE_ASK);
      pr1=1/pr1;
      for(int y=0;y<3;y++){
         if(Symbol()==pairs[match[i]][y]){
            c++;
            if(y==0){
            level=fpi[match[i]]/(pr2*pr3);
            level=1/level;
            break;
            }
            if(y==1){
            level=fpi[match[i]]/(pr1*pr3);
            break;
            }
            if(y==2){
            level=fpi[match[i]]/(pr1*pr2);
            break;
            }
         }
      }
      //level=NormalizeDouble(level,Digits);
      //level+=i*Point;
      string name=Symbol()+DoubleToStr(i,0);
      drawLine(NormalizeDouble(level,Digits),name,col[i],1);
    
   }
   string k;
   for(i=0;i<size;i++){
      k=k+"\n";
      for(y=0;y<3;y++){
         k=k+pairs[match[i]][y]+" ";
      }
      k=k+StringConcatenate(" ( ",colst[i]," )",cal[match[i]]);
   }
   Comment("RINGS:\n",k);
}
      
void getFPI(int match[],double& fpi[])
{
   if(ArraySize(fpi)!=14)ArrayResize(fpi,14);
   int size=ArraySize(match);
   static double fpiavg[14][200];  
   static double lasttick[14];
   for(int i=0;i<size;i++){
      if(!UseBid){
         double aaa=(1/MarketInfo(pairs[match[i]][0],MODE_ASK))*MarketInfo(pairs[match[i]][1],MODE_ASK)*MarketInfo(pairs[match[i]][2],MODE_ASK);
      }else{
         aaa =(1/MarketInfo(pairs[match[i]][0],MODE_BID))*MarketInfo(pairs[match[i]][1],MODE_BID)*MarketInfo(pairs[match[i]][2],MODE_BID);
      }
      if(aaa!=lasttick[match[i]]){
         lasttick[match[i]]=aaa;
         for(int y=200-1;y>0;y--){
            fpiavg[match[i]][y]=fpiavg[match[i]][y-1];
         }
         fpiavg[match[i]][0]=aaa;
         int c=0;double total=0;
         while(fpiavg[match[i]][c]!=0){
            total+=fpiavg[match[i]][c];
            c++;
         }
         //if(c<3)cal[match[i]]=" (Calibrating) ";else cal[match[i]]="";
         
         fpi[match[i]]=total/c;
         Print("FPI new average on ",i," # ",c,"  avg :",fpi[match[i]]);
      }
   }
}
         
      
void drawLine(double lvl,string name, color Col,int type){
   if(ObjectFind(name) != 0){
      ObjectCreate(name, OBJ_HLINE, 0, Time[0], lvl,Time[0],lvl);
      if(type == 1)
         ObjectSet(name, OBJPROP_STYLE, STYLE_SOLID);
      else
         ObjectSet(name, OBJPROP_STYLE, STYLE_DOT);
      ObjectSet(name, OBJPROP_COLOR, Col);
      ObjectSet(name,OBJPROP_WIDTH,1);
   }else{
      ObjectDelete(name);
      ObjectCreate(name, OBJ_HLINE, 0, Time[0], lvl,Time[0],lvl);
      if(type == 1)
         ObjectSet(name, OBJPROP_STYLE, STYLE_SOLID);
      else
         ObjectSet(name, OBJPROP_STYLE, STYLE_DOT);
      ObjectSet(name, OBJPROP_COLOR, Col);        
      ObjectSet(name,OBJPROP_WIDTH,1);
   }
}
      
         