//+------------------------------------------------------------------+
//|                                              RIDI_LEVELS_MT4.mq4 |
//|                                     Copyright  2004, RIDI Corp. |
//|                                               http://www.ridi.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, RIDI Corp."
#property link      "http://www.ridi.ru"

#property indicator_chart_window
extern double UpperLevel = 0;
extern double LowerLevel = 0;
extern datetime AnalysisBegin = D'1980.01.01 00:00';
extern datetime AnalysisEnd = D'2030.01.01 00:00';
extern int QuantityLevels = 9;
extern int QuantityLevelsD = 9;
extern int QuantityLevelsW = 9;
extern int DeviationLevel = 5;
extern int DeviationLevelD = 10;
extern int DeviationLevelW = 20;
extern int RightModelLevel = 4;
extern int LeftModelLevel = 4;
extern int RightModelLevelD = 3;
extern int LeftModelLevelD = 3;
extern int RightModelLevelW = 3;
extern int LeftModelLevelW = 3;
extern int DistanceLevels = 0;
extern int DistanceLevelsD = 0;
extern int DistanceLevelsW = 0;
extern color Color = C'Blue';
extern int TypeLines = 0;
extern int WidthLine = 1;
extern color ColorText = C'Blue';
extern int HeightText = 8;
extern bool ShowText = true;
extern color ColorLabels = C'Blue';
extern bool ShowLabels = true;
extern color ColorD = C'Red';
extern int TypeLinesD = 0;
extern int WidthLineD = 1;
extern color ColorTextD = C'Red';
extern int HeightTextD = 8;
extern bool ShowTextD = true;
extern color ColorLabelsD = C'Red';
extern bool ShowLabelsD = true;
extern color ColorW = C'Green';
extern int TypeLinesW = 0;
extern int WidthLineW = 1;
extern color ColorTextW = C'Green';
extern int HeightTextW = 8;
extern bool ShowTextW = true;
extern color ColorLabelsW = C'Green';
extern bool ShowLabelsW = true;
//+------------------------------------------------------------------+
//|                                              |
//+------------------------------------------------------------------+
double PLevels[3000]; datetime TLevels[3000]; int FLevels[3000];
datetime DateT;
double LDev, LDis, QLevelsMas[3];
int QLevels, QuanLevels, iBegin, iEnd, RML, LML , TypeL, mHeightText;
double mLow[]; double mHigh[]; datetime mTime[]; int mBars;
color mColor, mColorLabels, mColorText;
bool mShowLabels, mShowText;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   DateT = 0;       
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- TODO: add your code here
   Clear();  
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   if (DateT == Time[0]) return(0); 
      else if (DateT > 0) Clear();
         
   for (int i = 0; i < 3; i++)
     {
      OptionsExpert(i);
      if (UpperLevel > 0 && LowerLevel > 0) SearchChannel(); else LastLevels();
      QLevelsMas[i] = QLevels;
      DrawLevels(i);
     }
   
   DateT = Time[0];
   return(0);
  }
//+------------------------------------------------------------------+
//| Options of the expert                                            |
//+------------------------------------------------------------------+
void OptionsExpert(int type)
  {
   if (type == 0)
     {
      mBars = ArrayCopySeries(mLow, MODE_LOW, Symbol(), Period());
      ArrayCopySeries(mHigh, MODE_HIGH, Symbol(), Period());
      ArrayCopySeries(mTime, MODE_TIME, Symbol(), Period());
      RML = RightModelLevel; LML = LeftModelLevel;
      QuanLevels = QuantityLevels;
      LDev = DeviationLevel*Point;
      LDis = DistanceLevels*Point;
      TypeL = TypeLines; mHeightText = HeightText;
      mColor = Color; mColorLabels = ColorLabels; mColorText = ColorText;
      mShowLabels = ShowLabels; mShowText = ShowText;
      PeriodAnalysis();     
     }
   else if (type == 1)
     {
      mBars = ArrayCopySeries(mLow, MODE_LOW, Symbol(), PERIOD_D1);
      ArrayCopySeries(mHigh, MODE_HIGH, Symbol(), PERIOD_D1);
      ArrayCopySeries(mTime, MODE_TIME, Symbol(), PERIOD_D1);
      RML = RightModelLevelD; LML = LeftModelLevelD;
      QuanLevels = QuantityLevelsD;
      LDev = DeviationLevelD*Point;
      LDis = DistanceLevelsD*Point;
      TypeL = TypeLinesD; mHeightText = HeightTextD;
      mColor = ColorD; mColorLabels = ColorLabelsD; mColorText = ColorTextD;
      mShowLabels = ShowLabelsD; mShowText = ShowTextD;
      PeriodAnalysis();                 
     }
   else
     {
      mBars = ArrayCopySeries(mLow, MODE_LOW, Symbol(), PERIOD_W1);
      ArrayCopySeries(mHigh, MODE_HIGH, Symbol(), PERIOD_W1);
      ArrayCopySeries(mTime, MODE_TIME, Symbol(), PERIOD_W1);
      RML = RightModelLevelW; LML = LeftModelLevelW;
      QuanLevels = QuantityLevelsW;
      LDev = DeviationLevelW*Point;
      LDis = DistanceLevelsW*Point;
      TypeL = TypeLinesW; mHeightText = HeightTextW;
      mColor = ColorW; mColorLabels = ColorLabelsW; mColorText = ColorTextW;
      mShowLabels = ShowLabelsW; mShowText = ShowTextW;
      PeriodAnalysis();                 
     }
   if (LDis < LDev) LDis = LDev;      
  }  
//+------------------------------------------------------------------+
//|                                                     |
//+------------------------------------------------------------------+  
void PeriodAnalysis()
  {
   int i;
   if (AnalysisBegin == D'1980.01.01 00:00') iEnd = mBars;
   else
     {
      for (i = 0; i < mBars; i++)
         if (mTime[i] == AnalysisBegin) { iEnd = i; break; }
      if (i == mBars) iEnd = mBars;      
     }  
   if (AnalysisEnd == D'2030.01.01 00:00') iBegin = 0;
   else
     {
      for (i = 0; i < mBars; i++)
         if (mTime[i] == AnalysisEnd) { iBegin = i; break; }
      if (i == mBars) iBegin = 0;     
     }  
  }  
//+------------------------------------------------------------------+
//| Search in the channel                                            |
//+------------------------------------------------------------------+
void SearchChannel()
  {
   int mPos = 0;
   for(int i = iBegin; i < iEnd; i++)     
     {
      if (CheckLevel(i, 1))
         if (UpperLevel >= mHigh[i] && mHigh[i] >= LowerLevel)
           {        
            PLevels[mPos] = mHigh[i];
            TLevels[mPos] = mTime[i];
            FLevels[mPos] = 1;
            mPos++;
           }     
      if (CheckLevel(i, 2))
         if (UpperLevel >= mLow[i] && mLow[i] >= LowerLevel)
           {        
            PLevels[mPos] = mLow[i];
            TLevels[mPos] = mTime[i];
            FLevels[mPos] = 1;
            mPos++;
           }     
     }
   int j;  
   for(i = 0; i < mPos; i++)
      for(j = i + 1; j < mPos; j++)
         if (PLevels[i] >= PLevels[j] - LDev && 
             PLevels[i] <= PLevels[j] + LDev) 
            FLevels[i] = FLevels[i] + 1;
   int Max;
   int iTemp;
   double dTemp;
   i = 0;
   while (i < QuanLevels && i < mPos)
     {
      Max = i;
      for(j = i + 1; j < mPos; j++)
         if (FLevels[j] > FLevels[Max]) Max = j;
      if (FLevels[Max] == 0) break;    
      for(j = i-1; j >= 0; j--)   
         if (PLevels[j]-LDis <= PLevels[Max] && PLevels[Max] <= PLevels[j]+LDis) break;
      if (j < 0)
        {
         dTemp = PLevels[Max]; PLevels[Max] = PLevels[i]; PLevels[i] = dTemp;
         iTemp = TLevels[Max]; TLevels[Max] = TLevels[i]; TLevels[i] = iTemp;
         iTemp = FLevels[Max]; FLevels[Max] = FLevels[i]; FLevels[i] = iTemp;
         i++;        
        }
      else FLevels[Max] = 0;              
     }
   QLevels = i;          
  }
//+------------------------------------------------------------------+
//| Check on a level                                                 |
//+------------------------------------------------------------------+  
bool CheckLevel(int pos, int type)
  {
   //   
   if (type == 1)
     {
      for(int i = pos - 1; i >= pos - RML && pos - RML > 0; i--) 
         if (mHigh[pos] < mHigh[i]) break;
      if (i < pos - RML)
        {
         for(i = pos + 1; i <= pos + LML && pos + LML < mBars; i++) 
            if (mHigh[pos] < mHigh[i]) break;    
         if (i > pos + LML)
           {
            return(true); 
           }
        }
     }
   //   
   if (type == 2)
     {
      for(i = pos - 1; i >= pos - RML && pos - RML > 0; i--) 
         if (mLow[pos] > mLow[i]) break;
      if (i < pos - RML)
        {
         for(i = pos + 1; i <= pos + LML && pos + LML < mBars; i++) 
            if (mLow[pos] > mLow[i]) break;    
         if (i > pos + LML)
           {
            return(true); 
           }
        }
     }  
   return(false);
  }  
//+------------------------------------------------------------------+
//|                                                  |
//+------------------------------------------------------------------+
void DrawLevels(int type)
  {
   string NameL;
   if (type == 0) { NameL = Period(); type = 1; } 
      else if (type == 1) { NameL = "D"; type = 3; }
         else { NameL = "W"; type = 5; }
   type++;    
   int iMinF = 1000000, iMaxF = 0;
   for(int i = 0; i < QLevels; i++)
     {
      if (FLevels[i] > iMaxF) iMaxF = FLevels[i];
      if (FLevels[i] < iMinF) iMinF = FLevels[i];
     }
     
   double KofColor;  
   int style, ColorL, ColorStep, ColorBegin, ColorEnd;
   
   if (TypeL > 0) 
     {
      switch(TypeL) 
        { 
         case 1: ColorStep=65794; ColorBegin=75; ColorEnd=125; break; //
         case 2: ColorStep=66049; ColorBegin=75; ColorEnd=125; break; //
         case 3: ColorStep=131329; ColorBegin=75; ColorEnd=125; break; //
         default: ColorStep=65793; ColorBegin=0; ColorEnd=200;
        }     
      KofColor = (ColorEnd - ColorBegin) / (iMaxF - iMinF);
     } 
   else 
     {
      KofColor = iMaxF - iMinF; KofColor++; KofColor /= 5;
     }

   for(i = 0; i < QLevels; i++)
     {
      ObjectCreate("Level"+NameL+","+i, OBJ_HLINE, 0, TLevels[i], PLevels[i]);
      if (TypeL > 0)
        {
         ColorL = ColorStep*MathRound(((iMaxF-FLevels[i])*KofColor)+ColorBegin);
         ObjectSet("Level"+NameL+","+i, OBJPROP_COLOR, ColorL);
         ObjectSet("Level"+NameL+","+i, OBJPROP_WIDTH, WidthLine);
        }
      else
        {
         ColorL = MathFloor((iMaxF-FLevels[i]) / KofColor);
         switch(ColorL) 
           { 
            case 0: style=0; break;
            case 1: style=1; break;
            case 2: style=3; break;
            case 3: style=4; break;
            case 4: style=2; break;
            default: Print("NOT style"); style=2;
           }                
         ObjectSet("Level"+NameL+","+i, OBJPROP_COLOR, mColor);
         ObjectSet("Level"+NameL+","+i, OBJPROP_WIDTH, 1);
         ObjectSet("Level"+NameL+","+i, OBJPROP_STYLE, style);
        }
      if (mShowLabels)
        {          
         ObjectCreate("LevelArrow"+NameL+","+i, OBJ_ARROW, 0, TLevels[i], PLevels[i]);
         ObjectSet("LevelArrow"+NameL+","+i, OBJPROP_COLOR, mColorLabels);
         ObjectSet("LevelArrow"+NameL+","+i, OBJPROP_ARROWCODE, 3);
        }
      if (mShowText)
        {
         ObjectCreate("LevelText"+NameL+","+i, OBJ_TEXT, 0, 
                      Time[0]+(Period()*60*type), PLevels[i]);
         ObjectSetText("LevelText"+NameL+","+i, ""+FLevels[i], 
                       mHeightText, "Time New Roman", mColorText);      
        } 
     } 
  }
//+------------------------------------------------------------------+
//|                                                          |
//+------------------------------------------------------------------+
void Clear()
  {
   string str;
   for (int i = 0; i < QLevelsMas[0]; i++)
     {
      ObjectDelete("Level"+Period()+","+i);
      if (ShowLabels) ObjectDelete("LevelArrow"+Period()+","+i);
      if (ShowText) ObjectDelete("LevelText"+Period()+","+i); 
     }
   for (i = 0; i < QLevelsMas[1]; i++)
     {
      ObjectDelete("LevelD,"+i);
      if (ShowLabelsD) ObjectDelete("LevelArrowD,"+i);
      if (ShowTextD) ObjectDelete("LevelTextD,"+i); 
     }
   for (i = 0; i < QLevelsMas[2]; i++)
     {
      ObjectDelete("LevelW,"+i);
      if (ShowLabelsW) ObjectDelete("LevelArrowW,"+i);
      if (ShowTextW) ObjectDelete("LevelTextW,"+i); 
     }          
  }
//+------------------------------------------------------------------+
//|                                                 |
//+------------------------------------------------------------------+  
void LastLevels()
  {
   QLevels = 0;
   int j, k = 0;
   for(int i = iBegin; i < iEnd && QLevels < QuanLevels; i++)
     {
      if (CheckLevel(i, 1))
        {
         for(j = QLevels - 1; j >= 0; j--)   
            if (PLevels[j]-LDis <= mHigh[i] && mHigh[i] <= PLevels[j]+LDis) break;                   
         if (j < 0)
           {
            PLevels[QLevels] = mHigh[i];
            TLevels[QLevels] = mTime[i];
            FLevels[QLevels] = 0;
            QLevels++;           
           }
        }
      if (CheckLevel(i, 2))
        {
         for(j = QLevels - 1; j >= 0; j--)   
            if (PLevels[j]-LDis <= mLow[i] && mLow[i] <= PLevels[j]+LDis) break;        
         if (j < 0)
           {
            PLevels[QLevels] = mLow[i];
            TLevels[QLevels] = mTime[i];
            FLevels[QLevels] = 0;
            QLevels++;           
           }
        }                   
     }
   for(i = iBegin; i < iEnd; i++)
     {
      if (CheckLevel(i, 1))
         for(j = QLevels - 1; j >= 0; j--)   
            if (PLevels[j]-LDev <= mHigh[i] && mHigh[i] <= PLevels[j]+LDev) 
               FLevels[j] = FLevels[j] + 1;      
      if (CheckLevel(i, 2))
         for(j = QLevels - 1; j >= 0; j--)   
            if (PLevels[j]-LDev <= mLow[i] && mLow[i] <= PLevels[j]+LDev) 
               FLevels[j] = FLevels[j] + 1;     
     }
  }  