//based on divergence indicators created by FX5, hazem@uk2.net
//modified by U.D.C., udc@seznam.cz
//----
#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_buffers 3
#property indicator_color1 Lime
#property indicator_color2 Red
#property indicator_color3 Magenta
//---- input parameters
extern string separator1 = "*** RSI Settings ***";
extern int    RSIPeriod=14;
extern string separator2 = "*** Indicator Settings ***";
extern bool   divergenceDetector = true;
extern bool   drawIndicatorTrendLines = true;
extern bool   drawPriceTrendLines = false;
extern bool   displayAlert = true;
extern bool   displayLabel = true;
extern int    arrowsDisplacement = 7;
extern string separator3 = "* If labels are disabled, corresponding";
extern string separator4 = "* WindowNumber must be set.";
extern string separator5 = "* (Indicator windows are numbered";
extern string separator6 = "* from up, first WindowNumber is 1.}";
extern int    WindowNumber = 0;
//---- buffers
double bullishDivergence[];
double bearishDivergence[];
double rsi[];
//----
static datetime lastAlertTime;
static string   indicatorName;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0, DRAW_ARROW);
   SetIndexStyle(1, DRAW_ARROW);
   SetIndexStyle(2, DRAW_LINE);
//----   
   SetIndexBuffer(0, bullishDivergence);
   SetIndexBuffer(1, bearishDivergence);
   SetIndexBuffer(2, rsi);
//----   
   SetIndexArrow(0, 233);
   SetIndexArrow(1, 234);
//----

   if(displayLabel == true)
      indicatorName = "RSI_Div("+RSIPeriod+")";
   else indicatorName = "";
   IndicatorShortName(indicatorName);
   SetIndexLabel(2,indicatorName);

   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   for(int i = ObjectsTotal() - 1; i >= 0; i--)
     {
       string label = ObjectName(i);
       if(StringSubstr(label, 0, 19) == "RSI_DivergenceLine")
           ObjectDelete(label);   
     }
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int countedBars = IndicatorCounted();
   if(countedBars < 0)
       countedBars = 0;
   CalculateIndicator(countedBars);
//---- 
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalculateIndicator(int countedBars)
  {
   for(int i = Bars - countedBars; i >= 0; i--)
     {
       CalculateRSI(i);
       if(divergenceDetector == true)
       {
         CatchBullishDivergence(i + 2);
         CatchBearishDivergence(i + 2);
       }
     }              
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalculateRSI(int i)
  {
   rsi[i] = iRSI(NULL, 0, RSIPeriod, PRICE_CLOSE, i);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CatchBullishDivergence(int shift)
  {
   if(IsIndicatorTrough(shift) == false)
       return;  
   int currentTrough = shift;
   int lastTrough = GetIndicatorLastTrough(shift);
   if(rsi[currentTrough] > rsi[lastTrough] && Low[currentTrough] < Low[lastTrough])
     {
       bullishDivergence[currentTrough] = rsi[currentTrough] - arrowsDisplacement;

       if(drawPriceTrendLines == true)
           DrawPriceTrendLine(Time[currentTrough], Time[lastTrough], Low[currentTrough], 
                             Low[lastTrough], Green, STYLE_SOLID);

       if(drawIndicatorTrendLines == true)
          DrawIndicatorTrendLine(Time[currentTrough], Time[lastTrough], rsi[currentTrough],
                                 rsi[lastTrough], Green, STYLE_SOLID);

       if(displayAlert == true)
          DisplayAlert("RSI Classic BULL diverg.: ", currentTrough);  
     }
   if(rsi[currentTrough] < rsi[lastTrough] && Low[currentTrough] > Low[lastTrough])
     {
       bullishDivergence[currentTrough] = rsi[currentTrough] - arrowsDisplacement;

       if(drawPriceTrendLines == true)
           DrawPriceTrendLine(Time[currentTrough], Time[lastTrough], Low[currentTrough], 
                              Low[lastTrough], Green, STYLE_DOT);

       if(drawIndicatorTrendLines == true)                            
           DrawIndicatorTrendLine(Time[currentTrough], Time[lastTrough], rsi[currentTrough],
                                  rsi[lastTrough], Green, STYLE_DOT);

       if(displayAlert == true)
           DisplayAlert("RSI Reverse BULL diverg.: ", currentTrough);   
     }      
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CatchBearishDivergence(int shift)
  {
   if(IsIndicatorPeak(shift) == false)
       return;
   int currentPeak = shift;
   int lastPeak = GetIndicatorLastPeak(shift);

   if(rsi[currentPeak] < rsi[lastPeak] && High[currentPeak] > High[lastPeak])
     {
       bearishDivergence[currentPeak] = rsi[currentPeak] + arrowsDisplacement;
      
       if(drawPriceTrendLines == true)
           DrawPriceTrendLine(Time[currentPeak], Time[lastPeak], High[currentPeak], 
                              High[lastPeak], Red, STYLE_SOLID);
                            
       if(drawIndicatorTrendLines == true)
           DrawIndicatorTrendLine(Time[currentPeak], Time[lastPeak], rsi[currentPeak],
                                  rsi[lastPeak], Red, STYLE_SOLID);

       if(displayAlert == true)
           DisplayAlert("RSI Classic BEAR diverg.: ", currentPeak);  
     }
   if(rsi[currentPeak] > rsi[lastPeak] && High[currentPeak] < High[lastPeak])
     {
       bearishDivergence[currentPeak] = rsi[currentPeak] + arrowsDisplacement;

       if(drawPriceTrendLines == true)
           DrawPriceTrendLine(Time[currentPeak], Time[lastPeak], High[currentPeak], 
                              High[lastPeak], Red, STYLE_DOT);

       if(drawIndicatorTrendLines == true)
           DrawIndicatorTrendLine(Time[currentPeak], Time[lastPeak], rsi[currentPeak],
                                  rsi[lastPeak], Red, STYLE_DOT);

       if(displayAlert == true)
           DisplayAlert("RSI Reverse BEAR diverg.: ", currentPeak);   
     }   
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool IsIndicatorPeak(int shift)
  {
   if(rsi[shift] >= rsi[shift+1] && rsi[shift] > rsi[shift+2] && 
      rsi[shift] > rsi[shift-1])
       return(true);
   else 
       return(false);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool IsIndicatorTrough(int shift)
  {
   if(rsi[shift] <= rsi[shift+1] && rsi[shift] < rsi[shift+2] && 
      rsi[shift] < rsi[shift-1])
       return(true);
   else 
       return(false);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int GetIndicatorLastPeak(int shift)
  {
   for(int i = shift + 5; i < Bars; i++)
     {
       if(rsi[i] >= rsi[i+1] && rsi[i] >= rsi[i+2] &&
          rsi[i] >= rsi[i-1] && rsi[i] >= rsi[i-2])
           return(i);
     }
   return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int GetIndicatorLastTrough(int shift)
  {
   for(int i = shift + 5; i < Bars; i++)
     {
       if(rsi[i] <= rsi[i+1] && rsi[i] <= rsi[i+2] &&
          rsi[i] <= rsi[i-1] && rsi[i] <= rsi[i-2])
           return(i);
     }
    return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void DisplayAlert(string message, int shift)
  {
   if(shift <= 2 && Time[shift] != lastAlertTime)
     {
       lastAlertTime = Time[shift];
       Alert(message, Symbol(), " , ", Period(), " min. chart");
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void DrawPriceTrendLine(datetime x1, datetime x2, double y1, 
                        double y2, color lineColor, double style)
  {
   string label = "RSI_DivergenceLine_v1.0# " + DoubleToStr(x1, 0);
   ObjectDelete(label);
   ObjectCreate(label, OBJ_TREND, 0, x1, y1, x2, y2, 0, 0);
   ObjectSet(label, OBJPROP_RAY, 0);
   ObjectSet(label, OBJPROP_COLOR, lineColor);
   ObjectSet(label, OBJPROP_STYLE, style);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void DrawIndicatorTrendLine(datetime x1, datetime x2, double y1, 
                            double y2, color lineColor, double style)
  {

   if(displayLabel == true)
   {
      int indicatorWindow = WindowFind(indicatorName);
      if(indicatorWindow < 0)
         return;
   }
   else indicatorWindow=WindowNumber;

   string label = "RSI_DivergenceLine_v1.0$# " + DoubleToStr(x1, 0);
   ObjectDelete(label);
   ObjectCreate(label, OBJ_TREND, indicatorWindow, x1, y1, x2, y2, 
                0, 0);
   ObjectSet(label, OBJPROP_RAY, 0);
   ObjectSet(label, OBJPROP_COLOR, lineColor);
   ObjectSet(label, OBJPROP_STYLE, style);
  }
//+------------------------------------------------------------------+



