//+------------------------------------------------------------------+
//|                                                  RSI_EMA_MTF.mq4 |
//|                                                          Kalenzo |
//|                                      bartlomiej.gorski@gmail.com |
//+------------------------------------------------------------------+
#property copyright "Kalenzo"
#property link      "bartlomiej.gorski@gmail.com"
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 DodgerBlue
#property indicator_color2 Lime

extern int RsiPeriod = 14;
extern int MaType = MODE_EMA;
extern int MaPeriod = 50;
extern int TimeFrame = 60;

double rsi[],
       ema[],
       rsiTF[],
       emaTF[];
       

bool status,pstatus;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   IndicatorBuffers(4);
   
   SetIndexBuffer(0,rsi);
   SetIndexBuffer(1,ema);
   
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,2);
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,1);
   
   SetIndexBuffer(2,rsiTF);
   SetIndexBuffer(3,emaTF);
   
   IndicatorShortName("MTF RSI "+tf());
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   
//----
     int bbshift,limit,limitTF;
     limit=Bars;
     limitTF = iBars(Symbol(),TimeFrame);
     
     for(int i=0; i<limitTF; i++) rsiTF[i] = iRSI(Symbol(),TimeFrame,RsiPeriod,PRICE_CLOSE,i);
     for(int j=0; j<limitTF; j++) emaTF[j] = iMAOnArray(rsiTF,0,MaPeriod,0,MaType,j);
     
     for(int t=0; t<limit; t++)
     {
         bbshift = iBarShift(Symbol(),TimeFrame,Time[t]);
         rsi[t] = rsiTF[bbshift];
         ema[t] = emaTF[bbshift];
     }

   if(rsi[0]<ema[0] && rsi[1]>ema[1] && status!=pstatus)
   {
     status=true;
     PlaySound("Alert.wav");
   }

   if(rsi[0]>ema[0] && rsi[1]<ema[1] && status!=pstatus)
   {
     status=false;
     PlaySound("Alert.wav");
   }

   pstatus=status;
//----
   return(0);
  }
//+------------------------------------------------------------------+

string tf()
{
   switch(TimeFrame)
   {
      case PERIOD_M1: return("M(1)");
      case PERIOD_M5: return("M(5)");
      case PERIOD_M15: return("M(15)");
      case PERIOD_M30: return("M(30)");
      case PERIOD_H1: return("H(1)");
      case PERIOD_H4: return("H(4)");
      case PERIOD_D1: return("D(1)");
      case PERIOD_W1: return("W(1)");
      case PERIOD_MN1: return("MN(1)");
      default:return("Unknown timeframe");
   }
}