//+------------------------------------------------------------------+
//|                                                  RSI_Label_A.mq4 |
//+------------------------------------------------------------------+
#property copyright "GDP"
#property link      "RSI_Label_A"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Red

#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_level1 85 
#property indicator_level2 15

extern int RSIPeriod=3;//14
extern int CountBars=500;
extern int LineSize  = 2;//1
extern int In_Window  = 4;//3
extern bool RSI_Script =true;

double RSIBuffer[];
double PosBuffer[];
double NegBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int deinit()
{
   ObjectDelete("Line1");  ObjectDelete("Line2"); 
  	return(0);
  }
int init()
  {
   string short_name;
//---- 2 additional buffers are used for counting.
   IndicatorBuffers(3);
   SetIndexBuffer(1,PosBuffer);
   SetIndexBuffer(2,NegBuffer);
//---- indicator line
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,LineSize);
   SetIndexBuffer(0,RSIBuffer);
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("RSI_Label_A");
   SetIndexLabel(0,"RSI_Label_A");
//----
   SetIndexDrawBegin(0,RSIPeriod);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Relative Strength Index                                          |
//+------------------------------------------------------------------+
int start()
  { 
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS)+0);
   SetIndexDrawBegin(0,Bars-CountBars); 
   int    i,counted_bars=IndicatorCounted();
   double rel,negative,positive;
//----
   if(Bars<=RSIPeriod) return(0);
//---- initial zero
   if(counted_bars<1)
      for(i=1;i<=RSIPeriod;i++) RSIBuffer[Bars-i]=0.0;
//----
   i=Bars-RSIPeriod-1;
   if(counted_bars>=RSIPeriod) i=Bars-counted_bars-1;
   while(i>=0)
     {
      double sumn=0.0,sump=0.0;
      if(i==Bars-RSIPeriod-1)
        {
         int k=Bars-2;
         //---- initial accumulation
         while(k>=i)
           {
            rel=Close[k]-Close[k+1];
            if(rel>0) sump+=rel;
            else      sumn-=rel;
            k--;
           }
         positive=sump/RSIPeriod;
         negative=sumn/RSIPeriod;
        }
      else
        {
         //---- smoothed moving average
         rel=Close[i]-Close[i+1];
         if(rel>0) sump=rel;
         else      sumn=-rel;
         positive=(PosBuffer[i+1]*(RSIPeriod-1)+sump)/RSIPeriod;
         negative=(NegBuffer[i+1]*(RSIPeriod-1)+sumn)/RSIPeriod;
        }
      PosBuffer[i]=positive;
      NegBuffer[i]=negative;
      if(negative==0.0) RSIBuffer[i]=0.0;
      else RSIBuffer[i]=100.0-100.0/(1+positive/negative);
      i--;
 {  
 
    if  ( RSI_Script )  
    {
       ObjectDelete("Line1");
       Line1( "Line1", 0, 0, 0);
       ObjectSetText( "Line1", "RSI @", 12, "Arial Bold", DeepSkyBlue );
 }
       ObjectDelete("Line2");
       Line2( "Line2", 0, 0, 0);
       ObjectSetText("Line2",DoubleToStr(RSIBuffer[0],2),12,"Arial Bold",White);
     } 
     }  
     }
          int Line1( string Text, int xOffset, int yOffset,int iCorner) //LINE
   {  ObjectCreate(Text,OBJ_LABEL         , In_Window, 0, 0 );
      ObjectSet   (Text,OBJPROP_CORNER    , iCorner);
      ObjectSet   (Text,OBJPROP_XDISTANCE , 1100 );//800      Hoe groter die getal, hoe meer REGS skuif die lesing.
      ObjectSet   (Text,OBJPROP_YDISTANCE , 30 );//10
      ObjectSet   (Text,OBJPROP_BACK      , True );
   } 
   int Line2( string Text, int xOffset, int yOffset,int iCorner) 
   {  ObjectCreate(Text,OBJ_LABEL         , In_Window , 0, 0 );
      ObjectSet   (Text,OBJPROP_CORNER    , iCorner);
      ObjectSet   (Text,OBJPROP_XDISTANCE , 1150 );//850
      ObjectSet   (Text,OBJPROP_YDISTANCE , 30 );//10
      ObjectSet   (Text,OBJPROP_BACK      , True );
   } 
     
//+------------------------------------------------------------------+