//+------------------------------------------------------------------+
//|                                              rsi_triple_hull.mq4 |
//|                   Copyright  2006, Matt Kennel. Licensed GPL v2 |
//|                                        http://www.metatrader.org |
//+------------------------------------------------------------------+

//
//  A smooth RSI indicator (in purple by default)
//  and a faster RSI (in white by default).
// 
// Uses three Hull MA's on velocity and volatility, then divides.
// 

#property copyright "Copyright  2006, Matt Kennel. Licensed GPL v2"
#property link      "http://www.metatrader.org"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Magenta
#property indicator_color2 White
#property indicator_level1 70
#property indicator_level2 30
#property indicator_level3 50
#property indicator_maximum 100
#property indicator_minimum 0

//---- input parameters
extern int Len=14; 
double rsi_triple_hull[];
double rsi_triple_hullfast[]; 

double rsi_triple_hullvalue, VelocityRaw, vel_HMA1, vel_HMA2, vel_HMA3, vol_HMA1, vol_HMA3;
double Mixing, MixingC, vel_1A, vel_1B, vel_2A, vel_3A, vol_HMA2;
double vel_3B, vol_1A, vol_1B, vol_2A, vol_2B, vol_3A, vol_3B, vel_2B;

int init() {
  SetIndexStyle(0,DRAW_LINE);
  SetIndexBuffer(0,rsi_triple_hull);
  IndicatorShortName("RSX_TripleHull("+Len+")");
  SetIndexStyle(1,DRAW_LINE);
  SetIndexBuffer(1,rsi_triple_hullfast); 
  Mixing = 3.0 / (Len + 2.0);
  MixingC = 1.0 - Mixing;
  
  return(0);
}

int deinit()
{
return(0);
}

int start()
{
  int counted_bars=IndicatorCounted(),limit,shift;

  if (counted_bars<0) return(-1);
  if (counted_bars>0) counted_bars--;
  limit=Bars-Len-2;
 //  if(counted_bars>Len) limit=Bars-counted_bars-1;

  for (shift=limit;shift>=0;shift--) {
    VelocityRaw = 100.0*(Close[shift]-Close[shift+1]); // velocity f8 - f10;
    
    //  a Hull MA.
    vel_1A = MixingC * vel_1A + Mixing * VelocityRaw;
    vel_1B = Mixing * vel_1A + MixingC * vel_1B;
    vel_HMA1 = vel_1A * 1.5 - vel_1B * 0.5;

    // another Hull MA
    vel_2A = MixingC * vel_2A + Mixing * vel_HMA1;
    vel_2B = Mixing * vel_2A + MixingC * vel_2B; 
    vel_HMA2 = vel_2A * 1.5 - vel_2B * 0.5;
    
    // Yet another Hull MA; 
    vel_3A = MixingC * vel_3A + Mixing * vel_HMA2;
    vel_3B = Mixing * vel_3A + MixingC * vel_3B;
    vel_HMA3 = vel_3A * 1.5 - vel_3B * 0.5;
    
    // Onto volatility. 
    vol_1A = MixingC * vol_1A + Mixing * MathAbs(VelocityRaw);
    vol_1B = Mixing * vol_1A + MixingC * vol_1B;
    vol_HMA1 = vol_1A * 1.5 - vol_1B * 0.5;

    // Hull MA
    vol_2A = MixingC * vol_2A + Mixing * vol_HMA1;
    vol_2B = Mixing * vol_2A + MixingC * vol_2B;
    vol_HMA2 = vol_2A * 1.5 - vol_2B * 0.5;
    
    // Hull MA
    vol_3A = MixingC * vol_3A + Mixing * vol_HMA2;
    vol_3B = Mixing * vol_3A + MixingC * vol_3B;
    vol_HMA3 = vol_3A * 1.5 - vol_3B * 0.5;

    rsi_triple_hull[shift] = (vel_HMA3 / vol_HMA3 + 1.0) * 50.0;
    rsi_triple_hullfast[shift] = (vel_HMA2 / vol_HMA2+1.0)*50.0; 
    
  }
return(0);
}

