//+------------------------------------------------------------------+
//|                                                      RSI_X2.mq4  |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Image3022"

#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_buffers 2
#property indicator_color1 DodgerBlue
#property indicator_color2 Red
#property indicator_width1 1
#property indicator_width2 1

extern int     RSI_Period       = 13,
               RSI_Period2      = 3;
              

double         RSIBuffer[],
               RSI2Buffer[];
               
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);

   SetIndexBuffer(0,RSIBuffer);
   SetIndexBuffer(1,RSI2Buffer);
   
   SetIndexLabel(0,"RSI");
   SetIndexLabel(1,"RSI 2");
   

   return(0);
}
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{

   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) counted_bars=0;
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
  
   for(int i = 0 ;i < limit ;i++){       
      RSIBuffer[i]      = iRSI(Symbol(),0,RSI_Period,PRICE_CLOSE,i);
   }
   
   for(int x = 0; x < (ArraySize(RSIBuffer));x++){
      RSI2Buffer[x] = iRSI(Symbol(),0,RSI_Period2,PRICE_CLOSE,x);
   }
//   SetLevelValue(1,RSIBuffer[0]);
   return(0);
}
//+------------------------------------------------------------------+

