//+------------------------------------------------------------------+
//|                                                  Random_Walk.mq4 |
//|                                                                  |
//|                                                          by Raff |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Forex-TSD.com "
#property link      "http://www.forex-tsd.com/"

#property indicator_chart_window
#property indicator_buffers 6
#property indicator_color1 DeepSkyBlue
#property indicator_color2 DeepSkyBlue
#property indicator_color3 DeepSkyBlue
#property indicator_color4 Gold
#property indicator_color5 Gold
#property indicator_color6 Gold
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 2
#property indicator_width4 2
#property indicator_width5 2
#property indicator_width6 2

//---- input parameters
extern bool   FullFractal = true;
extern int    UpperFractalShift   = 0;
extern int    LowerFractalShift   = 0;

extern int    ChannelPeriod = 50;

extern int    ATR_TimeFrame = 1440;
extern int    ATR_Period = 50;
extern double Factor = 0.2;
extern double Dividor = 5;
extern bool   HiLoPrice = false;

extern int    Shift = 0;

int CountBars = 1500;

//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
double ExtMapBuffer6[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexEmptyValue(0,0.0);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexEmptyValue(1,0.0);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexEmptyValue(2,0.0);
   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3,ExtMapBuffer4);
   SetIndexEmptyValue(3,0.0);
   SetIndexStyle(4,DRAW_LINE);
   SetIndexBuffer(4,ExtMapBuffer5);
   SetIndexEmptyValue(4,0.0);
   SetIndexStyle(5,DRAW_LINE);
   SetIndexBuffer(5,ExtMapBuffer6);
   SetIndexEmptyValue(5,0.0);
   
   SetIndexShift(0,Shift);
   SetIndexShift(1,Shift);
   SetIndexShift(2,Shift);
   SetIndexShift(3,Shift);
   SetIndexShift(4,Shift);
   SetIndexShift(5,Shift);

   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| FractalsSupRes                                                   |
//+------------------------------------------------------------------+

int start()
  {
   if (CountBars>Bars-1) CountBars=Bars-1;
   for(int i=0;i<=CountBars;i++)
   {
     ExtMapBuffer1[i]=0;
     ExtMapBuffer2[i]=0;
     ExtMapBuffer3[i]=0;
     ExtMapBuffer4[i]=0;
     ExtMapBuffer5[i]=0;
     ExtMapBuffer6[i]=0;
   }

  double Factor1 = Factor;
  double Factor2 = 2*Factor;
  double Factor3 = 4*Factor;
  int    FraL = Fractal("L");
  int    FraU = Fractal("U");

   for (int shift=FraL;shift>=0;shift--)
      {
       ExtMapBuffer1[shift]=iCustom(NULL,0,"ATRstopLine",ATR_TimeFrame,ATR_Period,Factor1,Dividor,FraL,true,HiLoPrice,0,shift);
       ExtMapBuffer2[shift]=iCustom(NULL,0,"ATRstopLine",ATR_TimeFrame,ATR_Period,Factor2,Dividor,FraL,true,HiLoPrice,0,shift);
       ExtMapBuffer3[shift]=iCustom(NULL,0,"ATRstopLine",ATR_TimeFrame,ATR_Period,Factor3,Dividor,FraL,true,HiLoPrice,0,shift);
      }  

   for (shift=FraU;shift>=0;shift--)
      {
       ExtMapBuffer4[shift]=iCustom(NULL,0,"ATRstopLine",ATR_TimeFrame,ATR_Period,Factor1,Dividor,FraU,false,HiLoPrice,0,shift);
       ExtMapBuffer5[shift]=iCustom(NULL,0,"ATRstopLine",ATR_TimeFrame,ATR_Period,Factor2,Dividor,FraU,false,HiLoPrice,0,shift);
       ExtMapBuffer6[shift]=iCustom(NULL,0,"ATRstopLine",ATR_TimeFrame,ATR_Period,Factor3,Dividor,FraU,false,HiLoPrice,0,shift);
      }  

  
   return(0);
  }

//+------------------------------------------------------------------+

bool Fractal (string F)
  {
  int US=0;
  int LS=0;
  if (CountBars>Bars-1) CountBars=Bars-1;

   for (int i=1;i<=CountBars;i++)
     {
     double Ufractal = iCustom(NULL,0,"Fractals_H1_H4_D1",FullFractal,0,i);
     double Lfractal = iCustom(NULL,0,"Fractals_H1_H4_D1",FullFractal,1,i);
     double HHprice = High[Highest(NULL,0,MODE_HIGH,ChannelPeriod,i)];
     double LLprice = Low[Lowest(NULL,0,MODE_LOW,ChannelPeriod,i)];

      if (F=="U" && Ufractal>0 && Ufractal -(Ask-Bid)==HHprice)
           {
           if(US==UpperFractalShift) return(i);
           US=US+1;
           }  
      if (F=="L" && Lfractal>0 && Lfractal +(Ask-Bid)==LLprice)
           {
           if(LS==LowerFractalShift) return(i);
           LS=LS+1;
           }
     }
   return(0);   
  }  
//+------------------------------------------------------------------+


