//+------------------------------------------------------------------+
//|                                                     Range_v2.mq4 |
//|                                  Copyright  2006, Forex-TSD.com |
//|                         Written by IgorAD,igorad2003@yahoo.co.uk |   
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |                                      
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Forex-TSD.com "
#property link      "http://www.forex-tsd.com/"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 DodgerBlue
#property indicator_color2 Tomato
#property indicator_color3 Lime
#property indicator_color4 Orange

#property indicator_width1 0
#property indicator_width2 0
#property indicator_width3 2
#property indicator_width4 2
#property indicator_style1 2
#property indicator_style2 2

extern int TimeFrame =1440;
extern int Shift     =   0;

double UpBuffer[];
double DnBuffer[];
double OpenBuffer[];
double CloseBuffer[];

int init()
{
   string short_name;
   //IndicatorBuffers(4);
   
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,UpBuffer);
   SetIndexLabel(0,"High");
   SetIndexDrawBegin(0,0);
   
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,DnBuffer);
   SetIndexLabel(1,"Low");
   SetIndexDrawBegin(1,0);
   
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,OpenBuffer);
   SetIndexLabel(2,"Open");
   SetIndexDrawBegin(2,0);
   
   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3,CloseBuffer);
   SetIndexLabel(3,"Close");
   SetIndexDrawBegin(3,0);
   
   SetIndexShift(0,Shift*TimeFrame/Period());
   SetIndexShift(1,Shift*TimeFrame/Period());
   SetIndexShift(2,Shift*TimeFrame/Period());
   SetIndexShift(3,Shift*TimeFrame/Period());
   
   short_name="Range_v2("+TimeFrame+")";
   IndicatorShortName(short_name);
   
   
   switch(TimeFrame) 
   {
   case 1    : TimeFrame=PERIOD_M1;  break; 
   case 5    : TimeFrame=PERIOD_M5;  break;
   case 15   : TimeFrame=PERIOD_M15; break;
   case 30   : TimeFrame=PERIOD_M30; break;
   case 60   : TimeFrame=PERIOD_H1;  break;
   case 240  : TimeFrame=PERIOD_H4;  break;
   case 1440 : TimeFrame=PERIOD_D1;  break;
   case 7200 : TimeFrame=PERIOD_W1;  break;
   case 28800: TimeFrame=PERIOD_MN1; break;
   default  : TimeFrame=Period();   break;
   }
return(0);
}

int start()
{
   datetime TimeArray[];
   int i=0,y=0, prevy=0;  
   int counted_bars=IndicatorCounted();
   double LowArray[],HighArray[],OpenArray[],CloseArray[];
   
   
      if (TimeFrame<Period()) 
      {
      SetIndexDrawBegin(0,Bars);  
      SetIndexDrawBegin(1,Bars);
      Comment("Incorrect TimeFrame");
      return(0);
      }

   if ( counted_bars > 0 )  int limit=Bars-counted_bars+TimeFrame/Period();
   if ( counted_bars < 0 )  return(0);
   if ( counted_bars ==0 )  limit=Bars-1; 
     
   ArrayCopySeries(TimeArray,MODE_TIME,Symbol(),TimeFrame);
   ArrayCopySeries(LowArray,MODE_LOW,Symbol(),TimeFrame);  
   ArrayCopySeries(HighArray,MODE_HIGH,Symbol(),TimeFrame);
   ArrayCopySeries(OpenArray,MODE_OPEN,Symbol(),TimeFrame);  
   ArrayCopySeries(CloseArray,MODE_CLOSE,Symbol(),TimeFrame);
     
      for(i=0,y=0;i<limit;i++)
      {
      prevy = y;
      if (Time[i]<TimeArray[y]) y++;
      UpBuffer[i]=HighArray[y];    
      DnBuffer[i]=LowArray[y];
      OpenBuffer[i]=OpenArray[y];    
      
      if(y!=prevy) 
      CloseBuffer[i]=CloseArray[y];
      else CloseBuffer[i]=CloseArray[prevy];
      
      } 
   return(0);
}