//+------------------------------------------------------------------+
//|                                                           it.mq4 |
//|                 Copyright  2005, tageiger aka fxid10t@yahoo.com |
//|                                        http://www.metatrader.org |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, tageiger aka fxid10t@yahoo.com"
#property link      "http://www.metatrader.org"
#include <WinUser32.mqh>

extern int        Max.Trendlines    =13;

extern int        Margin.Per.Lot    =100;    //Account Margin Cost for 1 full lot
extern double     MaximumRisk       =0.02;   //%account balance to risk per position
extern double     DecreaseFactor    =3;      //lot size divisor(reducer) during loss streak

extern int        Magic             =1440;
extern string     comment           ="m it.d";   

double spread;spread=Ask-Bid;
int b,s,c,k,cnt,ticket;
double red,blue,daily,weekly;


int init(){return(0);}
int deinit(){return(0);}
int start(){
   if(Bars<720) {return(0);}
/*   if(!IsTesting() && c<=0) {
      MessageBox("Be sure that the \"Instant TrendLine\"\n"+
                 " custom indicator are attached to your chart.\n"+
                 " Press \"F8,\" & select \"Common\" tab to check\n"
                 " \"show object descriptions.\"","FYI it",MB_OK|MB_ICONINFORMATION);
      c++;}
   
   if(IsTesting() || k<=0) {
      MessageBox("Given the nature of the custom indicator \n"+
                 "\"Support Resistance\", and the assignment of \n"+
                 "StopLoss and TakeProfit values taken from \n"+
                 "trend lines generated by this indicator, \n"+
                 "only live demo testing is of any benefit \n"+
                 "to you, the user of this ea.","Backtesting it",
                 MB_OK|MB_ICONSTOP);
      k++;}*/
   
   red=iCustom(Symbol(),0,"Instant TrendLine",0,0);
   blue=iCustom(Symbol(),0,"Instant TrendLine",1,0);
   daily=iCustom(Symbol(),0,"Support Resistance",1440,144,13,1,5,true,Aqua,DeepPink,Red,DarkOrange,DeepSkyBlue,Lime,0,0);
   weekly=iCustom(Symbol(),0,"Support Resistance",10080,144,13,1,5,true,Aqua,DeepPink,Red,DarkOrange,DeepSkyBlue,Lime,0,0);
   
   
   PosCounter();
   
   if(Open[1]<red && Close[1]>red && b==0) {
      ticket=OrderSend(Symbol(),
                        OP_BUY,
                        LotsOptimized(),
                        Close[0],
                        spread,
                        StopLoss(),
                        TakeProfit(),
                        Period()+comment,
                        Magic,
                        0,//OrderExpiration
                        Aqua);
                        if(ticket>0)   {
                            if(OrderSelect(ticket,SELECT_BY_TICKET,MODE_TRADES))
                                  {   Print(ticket); }
                            else Print("Error Opening Buy Order: ",GetLastError());
                            return(0);}}

   if(Open[1]>red && Close[1]<red && s==0) {
      ticket=OrderSend(Symbol(),
                        OP_SELL,
                        LotsOptimized(),
                        Close[0],
                        spread,
                        StopLoss(),
                        TakeProfit(),
                        Period()+comment,
                        Magic,
                        0,//OrderExpiration
                        Maroon);
                        if(ticket>0)   {
                              if(OrderSelect(ticket,SELECT_BY_TICKET,MODE_TRADES))
                                    {   Print(ticket); }
                              else Print("Error Opening Sell Order: ",GetLastError());
                              return(0);}}

   if(b>0 || s>0) {Mod.Order();}

   TrailStop();

   for(cnt=0;cnt<OrdersTotal();cnt++)  {
   OrderSelect(cnt,SELECT_BY_POS,MODE_TRADES);
      if((OrderTakeProfit()<=0 || OrderStopLoss()<=0) && OrderSymbol()==Symbol() &&
         OrderComment()==Period()+comment && OrderProfit()>OrderSwap())  {
               OrderClose(OrderTicket(),OrderLots(),Close[0],spread,Snow);}
      /*if(OrderStopLoss()<=0) { Mod.Order();}*/ }
   
   if(!IsTesting()) {Comments();}
   
   Old.Object.Delete();
   
return(0);}
//+---------------------------FUNCTIONS------------------------------+
void PosCounter() {
   b=0;s=0;
   for(int cnt=0;cnt<=OrdersTotal();cnt++)   {
      OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
      if(OrderSymbol()==Symbol() && OrderMagicNumber()==Magic &&
         OrderComment()==Period()+comment) {
         if(OrderType() == OP_SELL)     s++;
         if(OrderType() == OP_BUY)      b++;}}}

double LotsOptimized()  {
   double lot;
   int    orders=HistoryTotal();
   int    losses=0;
   lot=NormalizeDouble(AccountFreeMargin()*MaximumRisk/Margin.Per.Lot,2);
   if(DecreaseFactor>0) {
      for(int i=orders-1;i>=0;i--)  {
         if(OrderSelect(i,SELECT_BY_POS,MODE_HISTORY)==false) { Print("Error in history!"); break; }
         if(OrderSymbol()!=Symbol() || OrderType()>OP_SELL) continue;
         if(OrderProfit()>0) break;
         if(OrderProfit()<0) losses++; }
      if(losses>1) lot=NormalizeDouble(lot-lot*losses/DecreaseFactor,2);   }
   if(lot<0.01) lot=0.01;
return(lot);   }//end LotsOptimized


double StopLoss() {
   double sl=0;
   for(int o=0;o<ObjectsTotal();o++)  {
      if(Close[1]>red && ObjectGetValueByShift(ObjectName(o),0)<Open[1]) {
         sl=ObjectGetValueByShift(ObjectName(o),0);}//buy stoploss
      if(Close[1]<red && ObjectGetValueByShift(ObjectName(o),0)>Open[1])  {
         sl=ObjectGetValueByShift(ObjectName(o),0);}}//sell stoploss
return(sl);}//end StopLoss

double TakeProfit()  {
   double tp=0;
   for(int p=0;p<ObjectsTotal();p++)  {
      if(Close[1]>red && ObjectGetValueByShift(ObjectName(p),0)>=High[Highest(Symbol(),0,MODE_HIGH,144,0)]) {
         tp=ObjectGetValueByShift(ObjectName(p),0);}//buy tp
      if(Close[1]<red && ObjectGetValueByShift(ObjectName(p),0)<=High[Highest(Symbol(),0,MODE_HIGH,144,0)])  {
         tp=ObjectGetValueByShift(ObjectName(p),0);}}//sell tp
return(tp);}//end TakeProfit

void Mod.Order()   {
   for(int cnt=0;cnt<OrdersTotal();cnt++) {
   OrderSelect(cnt,SELECT_BY_POS,MODE_TRADES);
      if(OrderSymbol()==Symbol() && OrderComment()==Period()+comment)   {
         if(OrderType()==OP_BUYSTOP &&
            (NormalizeDouble(red,Digits)<OrderOpenPrice() ||
             OrderStopLoss()<=0))  {
               OrderModify(OrderTicket(),
                           NormalizeDouble(red,Digits),
                           StopLoss(),
                           OrderTakeProfit(),
                           0,
                           DarkSeaGreen);}
         if(OrderType()==OP_SELLSTOP &&
           (NormalizeDouble(red,Digits)>OrderOpenPrice() ||
            OrderStopLoss()<=0))   {
               OrderModify(OrderTicket(),
                           NormalizeDouble(red,Digits),
                           StopLoss(),
                           OrderTakeProfit(),
                           0,
                           Salmon);}}}}

void TrailStop()  {
   for(int tnc=0;tnc<OrdersTotal();tnc++) {
   OrderSelect(tnc,SELECT_BY_POS,MODE_TRADES);
   if(OrderSymbol()==Symbol() && OrderComment()==Period()+comment)   {
      if(OrderType()==OP_BUY && (OrderTakeProfit()==0 || OrderStopLoss()==0 ||
        (NormalizeDouble(red,Digits)>OrderOpenPrice() &&
         NormalizeDouble(red,Digits)>OrderStopLoss()))) {
            OrderModify(OrderTicket(),
                        OrderOpenPrice(),
                        NormalizeDouble(red,Digits),
                        OrderTakeProfit(),
                        0,
                        Blue);}                    
      if(OrderType()==OP_SELL && (OrderTakeProfit()==0 || OrderStopLoss()==0 ||
        (NormalizeDouble(red,Digits)<OrderOpenPrice() &&
         NormalizeDouble(red,Digits)<OrderStopLoss()))) {
            OrderModify(OrderTicket(),
                        OrderOpenPrice(),
                        NormalizeDouble(red,Digits),
                        OrderTakeProfit(),
                        0,
                        Orange);}}}}

void Comments()   {
   if(!IsTesting()) {
   Comment("Last Tick:",TimeToStr(CurTime(),TIME_DATE|TIME_SECONDS),"\n",
           "Instant Trendline","\n",
           "Red Trend: ",red,"\n",
           "Blue Trend: ",blue);  }}
           
void Old.Object.Delete()   {
   //ObjectsDeleteAll(0,22);
   if(ObjectsTotal()>Max.Trendlines) {
   ObjectsDeleteAll(0,OBJ_TREND);}}


