//+------------------------------------------------------------------+
//|                                           BB Channel indicator   |
//|                                                        (C) Mikkom |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Mikko"
#property link      "noneOfYOurBusiness"

//#property indicator_separate_window
#property indicator_chart_window
#property indicator_buffers 6
#property indicator_color1 Green
#property indicator_color2 Green
#property indicator_color3 Red
#property indicator_color4 Red
#property indicator_color5 White
#property indicator_color6 White

double highup[];
double lowup[];
double highdown[];
double lowdown[];
double highmiddle[];
double lowmiddle[];

// Hourly settings
extern int begin = 24; 
extern int end = 720; 
extern int step = 12; 
extern int deviation = 2;

int init() {

   IndicatorBuffers(6);
   
   SetIndexBuffer(0, highup);
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,2);
   SetIndexBuffer(1, lowup);     
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,2);
   SetIndexBuffer(2, highdown);
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,2);
   SetIndexBuffer(3, lowdown);     
   SetIndexStyle(3,DRAW_LINE,STYLE_SOLID, 2);
   SetIndexBuffer(4, highmiddle);
   SetIndexStyle(4,DRAW_LINE,STYLE_DOT,1);
   SetIndexBuffer(5, lowmiddle);     
   SetIndexStyle(5,DRAW_LINE,STYLE_DOT,1);

   
   IndicatorShortName("Mikko bbchannels "+begin+"-"+end+"("+step+")");
  
  // SetIndexDrawBegin(0, 0);  
   
   return(0);
}
  
int deinit() {
   return(0);
}

     
int start() {
       
   int counted_bars=IndicatorCounted();
  
   if(counted_bars < 0) 
       return(-1);
   if(counted_bars > 0) 
       counted_bars--;
       
   int limit = Bars - counted_bars;
   for(int i = limit; i >= 0; i--) {

      highup[i] = 0;
      lowup[i] = 100000;
      highdown[i] = 0;
      lowdown[i] = 100000;
      highmiddle[i] = 0;
      lowmiddle[i] = 100000;
      
       
      for(int j=begin; j<=end; j+=step) {
         double bbup = iBands(Symbol(),0,j,deviation,0,PRICE_OPEN,MODE_UPPER,i);
         double bbdown = iBands(Symbol(),0,j,deviation,0,PRICE_OPEN,MODE_LOWER,i);
         double bbmiddle= iBands(Symbol(),0,j,deviation,0,PRICE_OPEN,MODE_MAIN,i);

         if(bbup == 0 || bbdown == 0 || bbmiddle == 0) {
            highup[i] = 0;
            lowup[i] = 0;
            highdown[i] = 0;
            lowdown[i] = 0;
            highmiddle[i] = 0;
            lowmiddle[i] = 0;
            break;
         }

         if(bbup > highup[i])
            highup[i] = bbup;
         if(bbup < lowup[i])
            lowup[i] = bbup;

         if(bbdown > highdown[i])
            highdown[i] = bbdown;
         if(bbdown < lowdown[i])
            lowdown[i] = bbdown;

         if(bbmiddle > highmiddle[i])
            highmiddle[i] = bbmiddle;
         if(bbmiddle < lowmiddle[i])
            lowmiddle[i] = bbmiddle;
            
      }
       

   } 
   return(0);
}

