/*
  I like to moving, moving
  v1.21s (1.0 + smoothing (+level) + shifting)
  by ALeX  
*/


#property indicator_separate_window
#property indicator_buffers 7
#property indicator_color1 Green
#property indicator_color2 Blue
#property indicator_color3 Red
#property indicator_color4 Black
#property indicator_color5 RosyBrown
#property indicator_color6 Orange
#property indicator_color7 BlueViolet

extern int candles = 100;
extern int shift = 0;
extern int smooth_level = 1;

double bufIUSD[];
double bufIEUR[];
double bufIGBP[];
double bufICHF[];
double bufIJPY[];
double bufIAUD[];
double bufICAD[];

//string names[7] = {"USD", "EUR", "GBP", "CHF", "JPY", "AUD", "CAD"};

int init()
{
  SetIndexBuffer (0, bufIUSD);
  SetIndexBuffer (1, bufIEUR);
  SetIndexBuffer (2, bufIGBP);
  SetIndexBuffer (3, bufICHF);
  SetIndexBuffer (4, bufIJPY);
  SetIndexBuffer (5, bufIAUD);
  SetIndexBuffer (6, bufICAD);

  SetIndexLabel (0, "USD");
  SetIndexLabel (1, "EUR");
  SetIndexLabel (2, "GBP");
  SetIndexLabel (3, "CHF");
  SetIndexLabel (4, "JPY");
  SetIndexLabel (5, "AUD");
  SetIndexLabel (6, "CAD");

  SetIndexStyle (0, DRAW_LINE, EMPTY, 2);
  SetIndexStyle (1, DRAW_LINE, EMPTY, 2);
  SetIndexStyle (2, DRAW_LINE, EMPTY, 2);
  SetIndexStyle (3, DRAW_LINE, EMPTY, 2);
  SetIndexStyle (4, DRAW_LINE);
  SetIndexStyle (5, DRAW_LINE);
  SetIndexStyle (6, DRAW_LINE);

  return (0);
}


int start()
{
  int i, j;
  int to;
  double USD, maxUSD=0.0, maxEUR=0.0, maxGBP=0.0, maxCHF=0.0, maxJPY=0.0, maxAUD=0.0, maxCAD=0.0;


  to = candles+shift;
  if (to > Bars-10)
    to = Bars-10;

  for (i = shift; i < to; i++)
  {
    USD = MathPow (iClose("USDCHF",0,i)*iClose("USDJPY",0,i)*iClose("USDCAD",0,i)/iClose("EURUSD",0,i)/iClose("GBPUSD",0,i)/iClose("AUDUSD",0,i), 1.0/7.0);
    maxUSD = MathMax (maxUSD, USD);
    maxEUR = MathMax (maxEUR, USD*iClose("EURUSD",0,i));
    maxGBP = MathMax (maxGBP, USD*iClose("GBPUSD",0,i));
    maxCHF = MathMax (maxCHF, USD/iClose("USDCHF",0,i));
    maxJPY = MathMax (maxJPY, USD/iClose("USDJPY",0,i));
    maxAUD = MathMax (maxAUD, USD*iClose("AUDUSD",0,i));
    maxCAD = MathMax (maxCAD, USD/iClose("USDCAD",0,i));
  }

  for (i = shift; i < to; i++)
  {
    USD = MathPow (iClose("USDCHF",0,i)*iClose("USDJPY",0,i)*iClose("USDCAD",0,i)/iClose("EURUSD",0,i)/iClose("GBPUSD",0,i)/iClose("AUDUSD",0,i), 1.0/7.0);
    bufIUSD[i] = 100*USD/maxUSD;
    bufIEUR[i] = 100*USD*iClose("EURUSD",0,i)/maxEUR;
    bufIGBP[i] = 100*USD*iClose("GBPUSD",0,i)/maxGBP;
    bufICHF[i] = 100*USD/iClose("USDCHF",0,i)/maxCHF;
    bufIJPY[i] = 100*USD/iClose("USDJPY",0,i)/maxJPY;
    bufIAUD[i] = 100*USD*iClose("AUDUSD",0,i)/maxAUD;
    bufICAD[i] = 100*USD/iClose("USDCAD",0,i)/maxCAD;
  }

  // smoothing
  for (j = 0; j < smooth_level; j++)
  {
    for (i = shift+1; i < to-1; i++)
    {
      bufIUSD[i] = (bufIUSD[i]+bufIUSD[i+1]+bufIUSD[i-1]) / 3.0;
      bufIEUR[i] = (bufIEUR[i]+bufIEUR[i+1]+bufIEUR[i-1]) / 3.0;
      bufIGBP[i] = (bufIGBP[i]+bufIGBP[i+1]+bufIGBP[i-1]) / 3.0;
      bufICHF[i] = (bufICHF[i]+bufICHF[i+1]+bufICHF[i-1]) / 3.0;
      bufIJPY[i] = (bufIJPY[i]+bufIJPY[i+1]+bufIJPY[i-1]) / 3.0;
      bufIAUD[i] = (bufIAUD[i]+bufIAUD[i+1]+bufIAUD[i-1]) / 3.0;
      bufICAD[i] = (bufICAD[i]+bufICAD[i+1]+bufICAD[i-1]) / 3.0;
    }
  }


  return (0);
}

