//+------------------------------------------------------------------+
//|                                                                  |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2004, mietectec"
#property  link      ""
//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 3
#property  indicator_color1  DarkGreen
#property  indicator_color2  Red
#property  indicator_color3  Yellow
#property  indicator_minimum 0
#property  indicator_maximum 1

// Ergodic
extern int pq =2;
extern int pr = 10;
extern int ps = 5;
extern int trigger =3;
// MACD
extern int FastEma = 5;
extern int SlowEma = 13;
extern int SignalSMMA = 2;
extern string note9 = "Numbers of bars to calculate";
extern int MaxBars=150; 

//---- indicator buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   
//---- drawing settings

   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,4,indicator_color1);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexLabel(0,"BuyZone");
   
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,4,indicator_color2);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexLabel(1,"SellZone");
   
   SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID,4,indicator_color3);
   SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexLabel(2,"NoTradeZone");   

//---- name for DataWindow and indicator subwindow label

   string shortName = "Ergodic MACD ("+FastEma+","+SlowEma+","+SignalSMMA+") CCI ("+pq+","+pr+","+ps+","+trigger+")";
   IndicatorShortName(shortName);   
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Calculations                                    |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   
   int counted_bars=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   if(limit>MaxBars)limit=MaxBars;
 
//---- main loop
   
for(int i=0; i<limit; i++)
{
ExtMapBuffer1[i] = 0; ExtMapBuffer2[i] = 0;
double indErgoMain0 = iCustom(NULL, 0,"FX_Snipers_Ergodic_CCI_Trigger", pq, pr, ps, trigger,0, i);
double indErgoMain1 = iCustom(NULL, 0, "FX_Snipers_Ergodic_CCI_Trigger", pq, pr, ps, trigger,0, i+1);
double indErgoSignal0 = iCustom(NULL, 0, "FX_Snipers_Ergodic_CCI_Trigger",pq, pr, ps, trigger,1, i);
double indErgoSignal1 = iCustom(NULL, 0, "FX_Snipers_Ergodic_CCI_Trigger",pq, pr, ps, trigger,1,i+1);
double indMacdMain0 = iCustom(NULL, 0,"MACDsmoothed", FastEma, SlowEma, SignalSMMA, 0, i);
double indMacdMain1 = iCustom(NULL, 0, "MACDsmoothed", FastEma, SlowEma, SignalSMMA, 0, i+1);
double indMacdSignal0 = iCustom(NULL, 0, "MACDsmoothed",FastEma, SlowEma, SignalSMMA, 1, i);
double indMacdSignal1 = iCustom(NULL, 0, "MACDsmoothed",FastEma, SlowEma, SignalSMMA, 1, i+1);

if (indErgoMain0 > indErgoSignal0 && indMacdMain0 > indMacdSignal0)ExtMapBuffer1[i]=2;
else if (indErgoMain0 < indErgoSignal0 && indMacdMain0 < indMacdSignal0 )ExtMapBuffer2[i]=2;
else ExtMapBuffer3[i]=2;

}
return(0);
  }
//+------------------------------------------------------------------+

