//+------------------------------------------------------------------+
//|                                        multisymbol_color-RSI_LQ.mq4 |
//|                                                      Lq_sunshine |
//|                                         http://www.forex-tsd.com |
//+------------------------------------------------------------------+

#property indicator_separate_window
#property indicator_buffers 8


extern   int Periode=40;
extern bool invert_strength=0;
extern string NOTE = "Select symbol"; 
extern   int selected_Symbol=1;
extern string for_EURUSD = "enter: 1";
extern string for_EURGBP = "enter: 2";
extern string for_EURCHF = "enter: 3";
extern string for_EURJPY = "enter: 4";
extern string for_EURAUD = "enter: 5";
extern string for_USDCHF = "enter: 6";
extern string for_USDJPY = "enter: 7";
extern string for_USDCAD = "enter: 8";
extern string for_AUDUSD = "enter: 9";
extern string for_NZDUSD = "enter: 10";
extern string for_GBPJPY = "enter: 11";
extern string for_GBPCHF = "enter: 12";
extern string for_GBPUSD = "enter: 13";
extern string for_CHFJPY = "enter: 14";
extern string for_GOLD   = "enter: 15";

//---- buffers
   double     ExtBuffer0[];   
   double     ExtBuffer1[];
   double     ExtBuffer2[];
   double     ExtBuffer3[]; 
   double     ExtBuffer4[];   
   double     ExtBuffer5[];
   double     ExtBuffer6[]; 
   double     ExtBuffer7[];
   double     ExtBuffer8[]; 
    

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
  
   
   
   SetIndexBuffer(0,ExtBuffer0);
   SetIndexBuffer(1,ExtBuffer1);
   SetIndexBuffer(2,ExtBuffer2);
   SetIndexBuffer(3,ExtBuffer3);
   SetIndexBuffer(4,ExtBuffer4);
   SetIndexBuffer(5,ExtBuffer5);
   SetIndexBuffer(6,ExtBuffer6);
   SetIndexBuffer(7,ExtBuffer7);
   
   
   SetIndexStyle(0,DRAW_HISTOGRAM, EMPTY, 4, C'162,208,162');
   SetIndexStyle(1,DRAW_HISTOGRAM, EMPTY, 4, C'90,185,90');
   SetIndexStyle(2,DRAW_HISTOGRAM, EMPTY, 4, C'23,139,23');
   SetIndexStyle(3,DRAW_HISTOGRAM, EMPTY, 4, C'255,255,255');
   SetIndexStyle(4,DRAW_HISTOGRAM, EMPTY, 4, C'255,185,185');
   SetIndexStyle(5,DRAW_HISTOGRAM, EMPTY, 4, C'255,115,115');
   SetIndexStyle(6,DRAW_HISTOGRAM, EMPTY, 4, C'255,76,76');
   SetIndexStyle(7,DRAW_HISTOGRAM, EMPTY, 4, C'255,32,32');
   
 
  
//----
   return(1);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
    string currencypair;
  
  currencypair= choosesymbol(selected_Symbol);
   IndicatorShortName(currencypair+"("+Periode+")");
  
  
   int    counted_bars=IndicatorCounted();
   
//---- check for possible errors
   if (counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if (counted_bars>0) counted_bars--;
   
   int    pos=Bars-counted_bars;
 
   
   double ddraw;

 

//---- main calculation loop
   while(pos>=0)
     {          
         ddraw= iRSI(currencypair,0,Periode,PRICE_CLOSE,pos);         
         if (invert_strength==1)            
             ddraw=ddraw-(ddraw-50)*2;             //---- Inversion of the RSI
         
         if(ddraw<=48)           //---- RSI <= 48 draws RED blocks 
         
             if(ddraw<=48&&ddraw>44)   
                drawblock(0,0,0,0,5,0,0,0,pos);
             
                  else if(ddraw<=44&&ddraw>39)  
                          drawblock(0,0,0,0,0,5,0,0,pos);
                                      
                         else if(ddraw<=39&&ddraw>35)
                                drawblock(0,0,0,0,0,0,5,0,pos);
     
                          else  
                               drawblock(0,0,0,0,0,0,0,5,pos);
                        
                               
                               
          else if(ddraw>=52)     //---- RSI >= 52 draws green blocks
           
               if(ddraw>52&&ddraw<56)
                  drawblock(5,0,0,0,0,0,0,0,pos);
              
              else if(ddraw>=56&&ddraw<60)
                      drawblock(0,5,0,0,0,0,0,0,pos);
                  else  
                      drawblock(0,0,5,0,0,0,0,0,pos);
        
             else
              drawblock(0,0,0,5,0,0,0,0,pos);     //---- draw white block if there chart is ranging
   
   
         pos--;
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+


string choosesymbol(int selected_Symbol)
      {
       switch(selected_Symbol)
       {
       case 1:  return ("EURUSD");
       case 2:  return ("EURGBP"); 
       case 3:  return ("EURCHF");
       case 4:  return ("EURJPY");
       case 5:  return ("EURAUD");
       case 6:  return ("USDCHF");
       case 7:  return ("USDJPY");
       case 8:  return ("USDCAD");
       case 9:  return ("AUDUSD");
       case 10: return ("NZDUSD");
       case 11: return ("GBPJPY");
       case 12: return ("GBPCHF");
       case 13: return ("GBPUSD");
       case 14: return ("CHFJPY");
       case 15: return ("GOLD");
        }
      }
      
void drawblock(int a,int b,int c,int d,int e,int f,int g,int h,int pos)

{
         
               ExtBuffer0[pos]=a;    
               ExtBuffer1[pos]=b;
               ExtBuffer2[pos]=c;
               ExtBuffer3[pos]=d;
               ExtBuffer4[pos]=e;
               ExtBuffer5[pos]=f;
               ExtBuffer6[pos]=g;
               ExtBuffer7[pos]=h;
               return;
 }