//+------------------------------------------------------------------+
//|                                                    RSI-Alert.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"

#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_buffers 3
#property indicator_color1 Blue
#property indicator_color2 Black
#property indicator_color3 Black
#property indicator_width1 2
#property indicator_width2 1
#property indicator_width3 1
#property indicator_style1 STYLE_SOLID
#property indicator_style2 STYLE_DOT
#property indicator_style3 STYLE_DOT
//---- input parameters
extern int RSIPeriod=2;
extern int ApplyTo=0;
extern bool AlertMode=true;
extern int OverBought=97;
extern int OverSold=3;
//---- buffers
double RSIBuffer[];
double RSIOBBuffer[];
double RSIOSBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   string short_name;
//---- indicator lines
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,RSIBuffer);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,RSIOBBuffer);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,RSIOSBuffer);
//---- name for DataWindow and indicator subwindow label
   short_name="RSI-Alert("+RSIPeriod+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,short_name);
   SetIndexLabel(1,"OverBought");
   SetIndexLabel(2,"OverSold");
//----
   SetIndexDrawBegin(0,RSIPeriod);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Relative Strength Index                                          |
//+------------------------------------------------------------------+
int start()
  {
   int    i,counted_bars=IndicatorCounted();
//----
   if(Bars<=RSIPeriod) return(0);
//----
   i=Bars-RSIPeriod-1;
   if(counted_bars>=RSIPeriod) i=Bars-counted_bars-1;
   while(i>=0)
   {
      RSIBuffer[i]=iRSI(NULL,0,RSIPeriod,ApplyTo,i);
      RSIOBBuffer[i]=OverBought;
      RSIOSBuffer[i]=OverSold;
      i--;
   }
   
   if(AlertMode)
   {
      if(RSIBuffer[1]<OverBought && RSIBuffer[0]>=OverBought)
         Alert("RSI = "+ RSIBuffer[i]+ ", Sell.", Symbol ());
      else if(RSIBuffer[1]>OverSold && RSIBuffer[0]<=OverSold)
         Alert("RSI = "+ RSIBuffer[i]+ ", Buy.");
   }
//----
   return(0);
  }
//+------------------------------------------------------------------+