//+--------------------------------------------------------------------------------+
//|                         RSIOMAv2MA(Lite)             Kalenzo    fxtsd.com      |
//| Hornet(i-RSI) - HistLevel/Sig mod   Copyright  2004, MetaQuotes Software Corp.|
//|  FXtsd.com                                    web: http://www.fxservice.eu   ik|
//|                                           email: bartlomiej.gorski@gmail.com   |
//+--------------------------------------------------------------------------------+
//  The base for this indicator was orginal RSI attached with Metatrader.
//                                       ^ removed ^ :)|-<   Hornet  buchered by fxbs

#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"

#property indicator_separate_window
#property indicator_maximum 100
#property indicator_minimum 0
#property indicator_buffers 3
#property indicator_color1 Blue
#property indicator_color2 DarkViolet
#property indicator_color3 DodgerBlue
#property indicator_width1 2   
#property indicator_width2 1
#property indicator_width3 1   
#property indicator_level1 100
#property indicator_level2 80//76.4
#property indicator_level3 70//61.8
#property indicator_level4 50
#property indicator_level5 30//38.2
#property indicator_level6 20 //23.6
#property indicator_level7 0
#property indicator_levelcolor  SlateGray
//---- input parameters
extern int RSIOMA          = 14;
extern int RSIOMA_MODE     = MODE_EMA;
extern int RSIOMA_PRICE    = PRICE_CLOSE;

extern int Ma_RSIOMA       = 9,
           Ma_RSIOMA_MODE  = MODE_SMMA;

 extern int MaMa_RSIOMA       = 7,
            MaMa_RSIOMA_MODE  =MODE_SMMA;

//---- buffers
double RSIBuffer[];
double MABuffer1[];
double MaRsioma[];
double MaMaRsioma[];
string short_name;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   short_name = StringConcatenate("RSIOMA(",RSIOMA,")");   
   IndicatorBuffers(7);
   
   SetIndexBuffer(0,RSIBuffer);
   SetIndexBuffer(1,MaRsioma);
    SetIndexBuffer(2,MaMaRsioma);
  
   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
    SetIndexStyle(2,DRAW_LINE);
  
   SetIndexBuffer(3,MABuffer1);
         
   IndicatorShortName(short_name);

   SetIndexDrawBegin(0,RSIOMA);
   SetIndexDrawBegin(1,RSIOMA);
   SetIndexDrawBegin(2,RSIOMA);
   SetIndexShift(2,0);
 
   SetIndexLabel(0,"Rsioma ["+RSIOMA+"]("+RSIOMA_MODE+")");
   SetIndexLabel(1,"MaRsioma["+Ma_RSIOMA+"]("+Ma_RSIOMA_MODE+")");
   SetIndexLabel(2,"MaMaRsioma["+MaMa_RSIOMA+"]("+MaMa_RSIOMA_MODE+")");
  
   return(0);
  }
//+------------------------------------------------------------------+
//| Relative Strength Index                                          |
//+------------------------------------------------------------------+
int start()
  {
   int   i, ii; 
   int   counted_bars=IndicatorCounted();
//----
   if(Bars<=RSIOMA) return(0);
//---- initial zero
   if(counted_bars<1)
      for(i=1;i<=RSIOMA;i++) {RSIBuffer[Bars-i]=0.0;}
//----
   ii=Bars-RSIOMA-1;
   if(counted_bars>=RSIOMA) ii=Bars-counted_bars-1;
   i = ii;
   while(i>=0)
      {  MABuffer1[i]=iMA(Symbol(),0,RSIOMA,0,RSIOMA_MODE,RSIOMA_PRICE,i);
      i--;  }
   i=ii;
   while(i>=0)           
      {  RSIBuffer[i]=iRSIOnArray(MABuffer1,0,RSIOMA,i);
      i--;  }
   i=ii;   
   while(i>=0)
      {  MaRsioma[i] = iMAOnArray(RSIBuffer,0,Ma_RSIOMA,0,Ma_RSIOMA_MODE,i); 
      i--;}
   i=ii;  
   while(i>=0)
      {  MaMaRsioma[i] = iMAOnArray(MaRsioma,0,MaMa_RSIOMA,1,MaMa_RSIOMA_MODE,i); 
      i--;}
 i=ii;  

//----
return(0);
}
//+------------------------------------------------------------------+

