//+--------------------------------------------------------------------------------+
//|                         RSIOMAv2 Only               Kalenzo    fxtsd.com       |
//|   RSIOMA only (- Hist/Sig mod)     Copyright  2004, MetaQuotes Software Corp. |
//|  Hornet's i-RSI mod                           web: http://www.fxservice.eu  ik |
//|  FXtsd.com                                email: bartlomiej.gorski@gmail.com   |
//+--------------------------------------------------------------------------------+
//  The base for this indicator was orginal RSI attached with Metatrader.
//                                     ^ removed ^^^ :)|-<   hornet; buchered by fxbs

#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"

#property indicator_separate_window
#property indicator_maximum 100
#property indicator_minimum 0
#property indicator_buffers 1
#property indicator_color1 MediumBlue
#property indicator_width1 2   
#property indicator_level1 100
#property indicator_level2 80//76.4
#property indicator_level3 70//61.8
#property indicator_level4 50
#property indicator_level5 30//38.2
#property indicator_level6 20 //23.6
#property indicator_level7 0
#property indicator_levelcolor  SlateGray
//---- input parameters
extern int RSIOMA          = 14;
extern int RSIOMA_MODE     = MODE_EMA;
extern int RSIOMA_PRICE    = PRICE_CLOSE;
//---- buffers
double RSIBuffer[];
double MABuffer1[];

string short_name;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   short_name = StringConcatenate("RSIOMA(",RSIOMA,")");   
   IndicatorBuffers(7);
   
   SetIndexBuffer(0,RSIBuffer);
   
   SetIndexStyle(0,DRAW_LINE);
   
  SetIndexBuffer(2,MABuffer1);
         
   IndicatorShortName(short_name);

   SetIndexDrawBegin(0,RSIOMA);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Relative Strength Index                                          |
//+------------------------------------------------------------------+
int start()
  {
   int   i, ii; 
   int   counted_bars=IndicatorCounted();
   double rel,negative,positive;
//----
   if(Bars<=RSIOMA) return(0);
//---- initial zero
   if(counted_bars<1)
      for(i=1;i<=RSIOMA;i++) {RSIBuffer[Bars-i]=0.0;}
//----
   ii=Bars-RSIOMA-1;
   if(counted_bars>=RSIOMA) ii=Bars-counted_bars-1;
   i = ii;
   while(i>=0)
      {  MABuffer1[i]=iMA(Symbol(),0,RSIOMA,0,RSIOMA_MODE,RSIOMA_PRICE,i);
      i--;  }
   i=ii;
   while(i>=0)           
      {  RSIBuffer[i]=iRSIOnArray(MABuffer1,0,RSIOMA,i);
      i--;  }
//----
return(0);
}
//+----------------------------------------------