//+----------------------------------------------------------------------------------+
//|      RSIOMA_v3LMA   by  Mladen  &  fxbs       Kalenzo            | fxtsd.com |ik|
//|  Hornet(RSIOnArray)  2007, FxTSD.com         MetaQuotes Software Corp.           |
//|  //Hist & Levels 20/80;30/70  CrossSig       web: http://www.fxservice.eu        |
//|  //Rsioma/MaRsioma X sig ()                  email: bartlomiej.gorski@gmail.com  |
//+----------------------------------------------------------------------------------+

#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/ Kalenzo|bartlomiej.gorski@gmail.com "

#property indicator_separate_window
#property indicator_buffers   2
//#property indicator_minimum -20
//#property indicator_maximum 110
#property indicator_color1     Blue
#property indicator_color2     BlueViolet
//
#property indicator_width1  2   
//
#property indicator_level1 300
#property indicator_level2 200   //76.4
#property indicator_level3 100   //61.8
#property indicator_level4 0
#property indicator_level5 -100   //38.2
#property indicator_level6 -200   //23.6
#property indicator_level7 -300   //23.6

#property indicator_levelcolor DarkSlateGray
//------------------------------------------

//---- input parameters
//

extern int    RSIOMA          = 14;
extern int    RSIOMA_MODE     = MODE_EMA;
extern int    RSIOMA_PRICE    = PRICE_CLOSE;
extern int    Ma_RSIOMA       = 20;
extern int    Ma_RSIOMA_MODE  = MODE_EMA;
//

extern int    BarsToCount         = 500;

//---- buffers
//
//
//    "indexes"
//

double MABuffer1[];
double RSIBuffer1[];

//
//
//    indexes
//
//

double RSIBuffer[];
double marsioma[];

//
//
//
//
//

int      correction;
datetime lastBarTime;
string   short_name;
double   lengthvar;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

int init()
{
   short_name = StringConcatenate("RSIOMA lsma[",RSIOMA,"]cci(",Ma_RSIOMA,")");   
   IndicatorShortName(short_name);
   
   //
   //
   //
   //
   //
   
   SetIndexBuffer(0,RSIBuffer);
   SetIndexBuffer(1,marsioma);
   //
   //  
   SetIndexLabel(0,"Rsioma("+RSIOMA+")");
   SetIndexLabel(1,"MaRsioma("+Ma_RSIOMA+")");
 
 
   //
   //
   //    additional buffer(s)
   //
   //


      correction  = RSIOMA+RSIOMA+Ma_RSIOMA;
      BarsToCount = MathMin(Bars,MathMax(BarsToCount,300));
          ArrayResize( MABuffer1 ,BarsToCount+correction);
          ArrayResize( RSIBuffer1,BarsToCount+correction);
          ArraySetAsSeries(MABuffer1 ,true);
          ArraySetAsSeries(RSIBuffer1,true);
                 lastBarTime = EMPTY_VALUE;

      //
      //
      //
   
   return(0);
}


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

int start()
{
   static bool init=false;
   int    counted_bars=IndicatorCounted();
   int    limit,i=0;

   //
   //
   //

               
   if(counted_bars<0) return(-1);
   if(lastBarTime != Time[0]) {
      lastBarTime  = Time[0];
                  counted_bars = 0;
      }         
      if(counted_bars>0) counted_bars--;
              limit=Bars-counted_bars;
              limit=MathMin(limit,BarsToCount+correction);
   
   //
   //
   //
   
        
      for(i=limit;i>=0;i--) 
      MABuffer1[i]  = LSMA(i,RSIOMA,false,RSIBuffer1);
//      for(i=limit;i>=0;i--) RSIBuffer1[i] = iRSIOnArray(MABuffer1,0,RSIOMA,i);
  //Sample:     double val=iCustom(NULL, 0, "SampleInd",13,1,0);

       for(i=limit;i>=0;i--) 
       RSIBuffer1[i] = iCCIOnArray(MABuffer1,0,RSIOMA,i);
//double iRSIOnArray( double array[], int total, int period, int shift) 
//double iCCIOnArray( double array[], int total, int period, int shift) 
//double iMomentumOnArray( double array[], int total, int period, int shift) 

      for(i=limit;i>=0;i--)
      {
         RSIBuffer[i]= RSIBuffer1[i];
         marsioma[i] = LSMA(i,Ma_RSIOMA,true,RSIBuffer1);
           
         //
         //
         //

         }

   //
   //
   //
   
   for (i=0;i<indicator_buffers;i++) SetIndexDrawBegin(i,Bars-BarsToCount);
   return(0);
}


//+------------------------------------------------------------------+
//
//
//
//
//

double LSMA(int shift,int period,bool onArray,double& values[])
{
   double sum = 0;
   double res = 0;


   lengthvar   = period + 1;
   lengthvar   /= 3;

   //
   //
   //
   //
   //
   
   for(int i = period; i >= 1 ; i--)
      if (onArray && (shift+period-i) <= (BarsToCount+correction))
               sum += (i-lengthvar)*values[shift+period-i];
      else     sum += (i-lengthvar)* Close[shift+period-i];
      res = sum*6/(period*(period+1));
   
   //
   //
   //
   //
   //
   
   return(res);
}


//  {  MABuffer1[i]=iMA(Symbol(),0,RSIOMA,0,RSIOMA_MODE,RSIOMA_PRICE,i);
//double iMA( string symbol, int timeframe, int period, int ma_shift, int ma_method, int applied_price, int shift) 
//double iCustom( string symbol, int timeframe, string name, ..., int mode, int shift) 
/////
//  { marsioma[i] = iMAOnArray(RSIBuffer,0,Ma_RSIOMA,0,Ma_RSIOMA_MODE,i); 
//  double iMAOnArray( double array[], int total, int period, int ma_shift, int ma_method, int shift) 
////////
//double iRSIOnArray( double array[], int total, int period, int shift) 
//double iCCIOnArray( double array[], int total, int period, int shift) 
//double iMomentumOnArray( double array[], int total, int period, int shift) 
//double iStdDevOnArray( double array[], int total, int ma_period, int ma_shift, int ma_method, int shift) 
//double iCustom( string symbol, int timeframe, string name, ..., int mode, int shift) 
//Sample:     double val=iCustom(NULL, 0, "SampleInd",13,1,0);

