//+------------------------------------------------------------------+
//|                                                  SHI_Channel.mq4 |
//|                                 Copyright  2004, Shurka & Kevin |
//|                                 MTF by Michel                    |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, Shurka & Kevin"
#property link      ""

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Red

//---- input parameters
extern int Timeframe = 0;
extern int AllBars=240;
extern int BarsForFract=0;

double ExtMapBuffer1[];
int CurrentBar=0;
double Step=0;
int B1=-1,B2=-1;
int UpDown=0;
double P1=0,P2=0,PP=0;
int i=0,AB=300,BFF=0;
int ishift=0;
double iprice=0;
datetime T1,T2;
color Clr;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexArrow(0,164);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexEmptyValue(0,0.0);
   
   if(Timeframe == 0) Timeframe = Period();
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   DelObj();
//----
   return(0);
  }

void DelObj()
{
	ObjectDelete("TL1-"+Timeframe);
	ObjectDelete("TL2-"+Timeframe);
	ObjectDelete("MIDL-"+Timeframe);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
//---- 
	if ((AllBars==0) || (iBars(Symbol(),Timeframe)<AllBars)) AB=iBars(Symbol(),Timeframe); else AB=AllBars; //AB-  
	if (BarsForFract>0) 
		BFF=BarsForFract; 
	else
	{
		switch (Timeframe)
		{
			case 1: BFF=12; Clr=Turquoise ;break;
			case 5: BFF=48; Clr=SteelBlue ;break;
			case 15: BFF=24; Clr=Lime  ;break;
			case 30: BFF=24; Clr=Silver  ;break;
			case 60: BFF=12; Clr=Magenta  ;break;
			case 240: BFF=15; Clr=Yellow  ;break;
			case 1440: BFF=10; Clr=DarkOrange ;break;
			case 10080: BFF=6; Clr=Red  ;break;
			default: DelObj(); return(-1); break;
		}
	}
	CurrentBar=2; //   ,   "
	B1=-1; B2=-1; UpDown=0;
	while(((B1==-1) || (B2==-1)) && (CurrentBar<AB))
	{
		//UpDown=1     , UpDown=-1   
		// , UpDown=0     .
		//1  2 -    ,     .
		//1  2 -       

		if((UpDown<1) && (CurrentBar==iLowest(Symbol(),Timeframe,MODE_LOW,BFF*2+1,CurrentBar-BFF))) 
		{
			if(UpDown==0) { UpDown=-1; B1=CurrentBar; P1=iLow(Symbol(),Timeframe,B1); }
			else { B2=CurrentBar; P2=iLow(Symbol(),Timeframe,B2);}
		}
		if((UpDown>-1) && (CurrentBar==iHighest(Symbol(),Timeframe,MODE_HIGH,BFF*2+1,CurrentBar-BFF))) 
		{
			if(UpDown==0) { UpDown=1; B1=CurrentBar; P1=iHigh(Symbol(),Timeframe,B1); }
			else { B2=CurrentBar; P2=iHigh(Symbol(),Timeframe,B2); }
		}
		CurrentBar++;
	}
	if((B1==-1) || (B2==-1)) {DelObj(); return(-1);} //      300  8-)
	Step=(P2-P1)/(B2-B1);// ,   ,   
	P1=P1-B1*Step; B1=0;//      
	//      .
	ishift=0; iprice=0;
	if(UpDown==1)
	{ 
		PP=iLow(Symbol(),Timeframe,2)-2*Step;
		for(i=3;i<=B2;i++) 
		{
			if(iLow(Symbol(),Timeframe,i)<PP+Step*i) { PP=iLow(Symbol(),Timeframe,i)-Step*i; }
		}
		if(iLow(Symbol(),Timeframe,0)<PP) {ishift=0; iprice=PP;}
		if(iLow(Symbol(),Timeframe,1)<PP+Step) {ishift=1; iprice=PP+Step;}
		if(iHigh(Symbol(),Timeframe,0)>P1) {ishift=0; iprice=P1;}
		if(iHigh(Symbol(),Timeframe,1)>P1+Step) {ishift=1; iprice=P1+Step;}
	} 
	else
	{ 
		PP=iHigh(Symbol(),Timeframe,2)-2*Step;
		for(i=3;i<=B2;i++) 
		{
			if(iHigh(Symbol(),Timeframe,i)>PP+Step*i) { PP=iHigh(Symbol(),Timeframe,i)-i*Step;}
		}
		if(iLow(Symbol(),Timeframe,0)<P1) {ishift=0; iprice=P1;}
		if(iLow(Symbol(),Timeframe,1)<P1+Step) {ishift=1; iprice=P1+Step;}
		if(iHigh(Symbol(),Timeframe,0)>PP) {ishift=0; iprice=PP;}
		if(iHigh(Symbol(),Timeframe,1)>PP+Step) {ishift=1; iprice=PP+Step;}
	}
	//       ,     
	P2=P1+AB*Step;
	T1=iTime(Symbol(),Timeframe,B1);
   T2=iTime(Symbol(),Timeframe,AB);

	//    ,  0,   .
	if(iprice!=0) ExtMapBuffer1[ishift]=iprice;
	DelObj();
	//Comment (PP,P1);
	
	string Text = " Channel size = "+DoubleToStr(MathAbs(PP - P1)/Point,0)+" Slope = "+DoubleToStr(-Step/Point, 2);

	if (PP<P1)
	{
	ObjectCreate("TL1-"+Timeframe,OBJ_TREND,0,T2,PP+Step*AB,T1,PP); 
		ObjectSet("TL1-"+Timeframe,OBJPROP_COLOR,Clr); 
		ObjectSet("TL1-"+Timeframe,OBJPROP_WIDTH,1); 
		ObjectSet("TL1-"+Timeframe,OBJPROP_STYLE,STYLE_SOLID); 
		ObjectSetText("TL1-"+Timeframe,Text);
	ObjectCreate("TL2-"+Timeframe,OBJ_TREND,0,T2,P2,T1,P1); 
		ObjectSet("TL2-"+Timeframe,OBJPROP_COLOR,Clr); 
		ObjectSet("TL2-"+Timeframe,OBJPROP_WIDTH,1); 
		ObjectSet("TL2-"+Timeframe,OBJPROP_STYLE,STYLE_SOLID);
		ObjectSetText("TL2-"+Timeframe,Text); 
	ObjectCreate("MIDL-"+Timeframe,OBJ_TREND,0,T2,(P2+PP+Step*AB)/2,T1,(P1+PP)/2);
		ObjectSet("MIDL-"+Timeframe,OBJPROP_COLOR,Clr); 
		ObjectSet("MIDL-"+Timeframe,OBJPROP_WIDTH,1); 
		ObjectSet("MIDL-"+Timeframe,OBJPROP_STYLE,STYLE_DOT);
		ObjectSetText("MIDL-"+Timeframe,Text);
		}
		if (PP>P1)
	{
	ObjectCreate("TL2-"+Timeframe,OBJ_TREND,0,T2,PP+Step*AB,T1,PP); 
		ObjectSet("TL2-"+Timeframe,OBJPROP_COLOR,Clr); 
		ObjectSet("TL2-"+Timeframe,OBJPROP_WIDTH,1); 
		ObjectSet("TL2-"+Timeframe,OBJPROP_STYLE,STYLE_SOLID); 
		ObjectSetText("TL2-"+Timeframe,Text);
	ObjectCreate("TL1-"+Timeframe,OBJ_TREND,0,T2,P2,T1,P1); 
		ObjectSet("TL1-"+Timeframe,OBJPROP_COLOR,Clr); 
		ObjectSet("TL1-"+Timeframe,OBJPROP_WIDTH,1); 
		ObjectSet("TL1-"+Timeframe,OBJPROP_STYLE,STYLE_SOLID); 
		ObjectSetText("TL1-"+Timeframe,Text);
	ObjectCreate("MIDL-"+Timeframe,OBJ_TREND,0,T2,(P2+PP+Step*AB)/2,T1,(P1+PP)/2);
		ObjectSet("MIDL-"+Timeframe,OBJPROP_COLOR,Clr); 
		ObjectSet("MIDL-"+Timeframe,OBJPROP_WIDTH,1); 
		ObjectSet("MIDL-"+Timeframe,OBJPROP_STYLE,STYLE_DOT);
		ObjectSetText("MIDL-"+Timeframe,Text);
		}
//----

//----
   return(0);
  }
//+------------------------------------------------------------------+