//+------------------------------------------------------------------+
//|                                                       SMARSI.mq4 |
//|                          Typical RSI revised By TrendLaboratory  |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                       E-mail: igorad2004@list.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, TrendLaboratory Ltd."
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"

#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_level1 30
#property indicator_level2 70
#property indicator_buffers 2
#property indicator_color1 DodgerBlue
#property indicator_color2 Yellow
//---- input parameters
extern int RSIPeriod=14;
extern int MAPeriod=1;
extern int Price=0;
extern int Smooth=1;
//---- buffers
double RSIBuffer[];
double SmoothBuffer[];
double PosBuffer[];
double NegBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   string short_name;
//---- 2 additional buffers are used for counting.
   IndicatorBuffers(4);
   SetIndexBuffer(2,PosBuffer);
   SetIndexBuffer(3,NegBuffer);
//---- indicator line
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,RSIBuffer);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,SmoothBuffer);
//---- name for DataWindow and indicator subwindow label
   short_name="RSI("+RSIPeriod+","+MAPeriod+","+Price+","+Smooth+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,short_name);
   SetIndexLabel(1,"Smooth");
//----
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS)+4);

   SetIndexDrawBegin(0,RSIPeriod+Smooth);
   SetIndexDrawBegin(0,RSIPeriod+Smooth);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Relative Strength Index                                          |
//+------------------------------------------------------------------+
int start()
  {
   int    i,counted_bars=IndicatorCounted();
   double rel,negative,positive;
//----
   Comment(" Digits = ", MarketInfo(Symbol(),MODE_DIGITS));
   if(Bars<=RSIPeriod+Smooth) return(0);
//---- initial zero
   if(counted_bars<1)
      for(i=1;i<=RSIPeriod+Smooth;i++) RSIBuffer[Bars-i]=0.0;
//----
   i=Bars-RSIPeriod-Smooth-1;
   if(counted_bars>=RSIPeriod+Smooth) i=Bars-counted_bars-1;
   while(i>=0)
     {
      double sumn=0.0,sump=0.0;
      for (int k=RSIPeriod-1;k>=0;k--)
           { 
            rel=iMA(NULL,0,MAPeriod,0,MODE_SMA,Price,i+k)/Point-iMA(NULL,0,MAPeriod,0,MODE_SMA,Price,i+k+1)/Point;
            if(rel>0) sump+=rel;
            else      sumn-=rel;
           }
         positive=sump/RSIPeriod/Point;
         negative=sumn/RSIPeriod/Point;
      
      PosBuffer[i]=positive;
      NegBuffer[i]=negative;
      if(negative==0.0) RSIBuffer[i]=100.0;
      else 
      RSIBuffer[i]=100.0-100.0/(1.0+positive/negative);
      
      double AvgRange=0;
	     for (k=Smooth-1;k>=0;k--)
	     { 
          AvgRange+=RSIBuffer[i+k];
        }
       SmoothBuffer[i]=AvgRange/Smooth; 
      i--;
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+