//+------------------------------------------------------------------+
//|                                                 ZoneAnalysis.mq4 |
//|                         Copyright  2006, Diffusion Limited, LLC |
//|                     http://www.theprosperousstatesmen.com/trade/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Diffusion Limited, LLC"
#property link      "http://www.theprosperousstatesmen.com/trade/"

#property indicator_separate_window
//#property indicator_minimum 0
//#property indicator_maximum 0.01

#property indicator_buffers 2
#property indicator_color1 LightGreen
#property indicator_color2 Red


extern double retraceBreak=80;  //This is the amount that the wave must drawback before it counts. Typically if grid is 20 it must drawback 39 to insure closure.

double BuyHP=0,BuyLP=10000,SellHP=0,SellLP=10000;  //Initialize Buy and Sell High Points and Low Points significant high point and significant low point.

extern bool      WriteWave=false; //True will write the wave stats to a file.
int FileWaveHandle=0;
int CountedBars=0;
double BuyWave[],SellWave[];//The buffers to contain the pivot lines.


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
  string Amp=DoubleToStr(retraceBreak,0);
  string DatFile="WaveStats"+Amp+".dat";
  Print(DatFile);
  if(WriteWave)
   {
   FileWaveHandle=FileOpen(DatFile,FILE_CSV|FILE_WRITE,';');
   }


   int    draw_begin; 
   
//---- drawing settings
   SetIndexStyle(0,DRAW_ARROW);
    SetIndexArrow(0,158);
   SetIndexBuffer(0,BuyWave);
   SetIndexDrawBegin(0,draw_begin);
   
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1,158);
   SetIndexBuffer(1,SellWave);
   SetIndexDrawBegin(1,draw_begin);
   
   
   return(0);
  }
  
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
int deinit()
  {
   
   if(WriteWave) FileClose(FileWaveHandle);
   return(0);
  }

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
int start()
  {
  CountedBars=IndicatorCounted();
   
   //---- check for possible errors
   if (CountedBars<0) return(-1);
   
   int i=Bars-CountedBars-2;
   //int TimeBracketTicker=0;
   while(i>=0)
     {
     
         if(High[i+1]>BuyHP) BuyHP=High[i+1];
         if(Low[i+1]<BuyLP) BuyLP=Low[i+1];
       
         //Print("BuyHP ",BuyHP," BuyLP ",BuyLP);
         if(MathAbs(BuyHP-Low[i])>=retraceBreak*Point)
            {
            double BuyBreakValue=BuyHP-BuyLP;
            double BuyBreakValueNormalized=BuyBreakValue/(retraceBreak/2*Point);  //Will give the steps traveled.
               if(WriteWave)
                  {
                  if(FileWaveHandle<1) Print("File not found",GetLastError());if(FileWaveHandle>0)
                     {
                     //Print("Writing File Now in the regular loop");
                     FileWrite(FileWaveHandle,BuyBreakValueNormalized);
                     }
                  }
            
            
            BuyLP=Low[i];
            BuyHP=High[i];
            }
         
         if(High[i+1]>SellHP) SellHP=High[i+1];
         if(Low[i+1]<SellLP) SellLP=Low[i+1];
       
         //Print("SellHP ",SellHP," SellLP ",SellLP);
         if(MathAbs(SellLP-High[i])>=retraceBreak*Point) 
           {
           double SellBreakValue=SellHP-SellLP;
           double SellBreakValueNormalized=SellBreakValue/(retraceBreak/2*Point);  
           
           if(WriteWave)
                  {
                  if(FileWaveHandle<1) Print("File not found",GetLastError());if(FileWaveHandle>0)
                     {
                     //Print("Writing File Now in the regular loop");
                     FileWrite(FileWaveHandle,SellBreakValueNormalized);
                     }
                  }
           
           
           
           
           SellHP=High[i];
           SellLP=Low[i];
           }
      
      BuyWave[i]=(BuyHP-BuyLP)/Point;//BuyBreakValue/Point;//Normalized;
      SellWave[i]=(SellHP-SellLP)/Point;//SellBreakValue/Point;//Normalized;
      
      
      i--;
      
      
      
      
      
      
     
     }
     
  
  return(0);
  }












