//+------------------------------------------------------------------+
//|                                               STOCH-ALARM.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
// This program uses Zerolag SYOCH crossing 80 and 20 % to trigger a signal//
#property link      "http://www.metaquotes.net"
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Yellow
#property indicator_color2 Magenta


extern bool Alarmset=true;
//extern string Set="Set the # times you want";
extern int Alarmtimesbuy=2;
extern int Alarmtimessell=2;
extern int period=4;
extern double volfac=1.5;
//extern string str1="Enter P0 and P1 for slope";
extern int P0=0;
extern int P1=1;


double upbuffer[500];
double dnbuffer[500];
int sep,ba,sa;//b=Buy thresh s=Sell thresh.
static int alarmBar;  // keeps the bar where alarm has been fired
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
      SetIndexStyle(0,DRAW_ARROW,3,2);
      SetIndexArrow(0,233);//This is buy signal
      SetIndexBuffer(0, upbuffer);

      SetIndexStyle(1,DRAW_ARROW,3,2);
      SetIndexArrow(1,234);
      SetIndexBuffer(1,dnbuffer);
      if(Symbol()=="EURUSD"){sep=4;}
      if(Symbol()=="USDCHF"){sep=3;}
      if(Symbol()=="USDJPY"){sep=3;}
      if(Symbol()=="GBPUSD"){sep=3;}
      if(Symbol()=="EURJPY"){sep=20;}
      if(Symbol()=="GBPJPY"){sep=12;}
      if(Symbol()=="AUDUSD"){sep=3;}
      if(Symbol()=="USDCAD"){sep=12;}
    alarmBar = -1;  // alart has been never fired yet
      return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
   {
     return(0);
   }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
// int    counted_bars=IndicatorCounted();

int start()
{ 
 
int AlarmBuyCount,AlarmSellCount;
  
double ax0[500],ax1[500],ax2[500];
double ax3[500],ax4[500];
int xdown,xup;
   for(int cnt=500;cnt>=0;cnt--)
   {
    
    ax0[cnt]=iCustom(NULL,0,"T3MA",period,volfac,0,cnt);
    ax1[cnt+1]=iCustom(NULL,0,"T3MA",period,volfac,0,cnt+1);
    ax2[cnt+2]=iCustom(NULL,0,"T3MA",period,volfac,0,cnt+2);
    
    ax3[cnt]=iCustom(NULL,0,"T3MA",15,0.7,0,cnt);//trend
    ax4[cnt+1]=iCustom(NULL,0,"T3MA",15,0.7,0,cnt+1);
    double trendup=ax3[cnt]-ax4[cnt+1];//+ = up  - = down    
    
    if(ax0[cnt]-ax1[cnt+1]<0 && ax1[cnt+1]-ax2[cnt+2]>0){xdown=1;} else {xdown=0;}
    if((ax0[cnt]-ax1[cnt+1])>0 && (ax1[cnt+1]-ax2[cnt+2])<0){xup=1;} else {xup=0;}
    
    
    
    if(xdown==1){dnbuffer[cnt+1]=High[cnt+1]+(sep*Point);}
    if(xup==1){upbuffer[cnt+1]=Low[cnt+1]-(sep*Point);}
    }
    {    
      
//         if(xup==1 && Alarmset && AlarmBuyCount < Alarmtimesbuy ){ 
//           Alert (Symbol()," ",Period(),"  STOCH-ALARM 3  >> BUY ");}
// if sell buffer (i.e. upbuffer) has been set and
// if this is another bar than the bar alarm has been fired for the last time
         if(xup==1 && Alarmset && AlarmBuyCount < Alarmtimesbuy ){
           if(upbuffer[cnt+1] > 0 && alarmBar != Bars){ 
             alarmBar = Bars; // remember the bar alarm is fired on...
             Alert (Symbol()," ",Period(),"  STOCH-ALARM 3  >> BUY (bar: ", alarmBar, ") ");
             }
           }
           if(xup==1){AlarmBuyCount++;}     
       
       
//        if(xdown==1 && Alarmset && AlarmSellCount < Alarmtimessell ){ 
//           Alert (Symbol()," ",Period(),"  STOCH-ALARM 3  >> SELL ");}
       
        if(xdown==1 && Alarmset && AlarmSellCount < Alarmtimessell) {
          if( dnbuffer[cnt+1] > 0 && alarmBar != Bars){ 
             alarmBar = Bars;
             Alert (Symbol()," ",Period(),"  STOCH-ALARM 3  >> SELL (bar: ", alarmBar, ") ");
             }
           }
           if(xdown==1){AlarmSellCount++;}     
    
     }
      { double slope,bx0,bx1;
      
      bx0=iMA(NULL,PERIOD_H1,50,0,MODE_LWMA,PRICE_CLOSE,0);//PERIOD_H1
      bx1=iMA(NULL,PERIOD_H1,50,0,MODE_LWMA,PRICE_CLOSE,1);
      slope=(bx0-bx1)/Point;
      
      double cx0=iMA(NULL,PERIOD_D1,50,0,MODE_LWMA,PRICE_CLOSE,P0);//PERIOD_H1
      double cx1=iMA(NULL,PERIOD_D1,50,0,MODE_LWMA,PRICE_CLOSE,P1);
      double slope2=(cx0-cx1)/Point;
      
    
      
      
      Comment("SLOPE PIPS PER PERIOD_H1 = ",slope
      ,"\n\nSLOPE PIPS PER PERIOD_D1 = ",slope2," AT P0=",P0," & P1=",P1);
      
      
    }
return(0);
WindowRedraw();

}