//+------------------------------------------------------------------+
//|                                                  STR_Signals.mq4 |
//|                      Copyright  2006, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
#property link      "cja"

#property indicator_separate_window
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
  ObjectsDeleteAll(0,OBJ_LABEL);
  IndicatorShortName("STR"); 
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
//----
     

   double rsi_h4 = iRSI(NULL, PERIOD_H4, 9, PRICE_CLOSE, 0);
   double rsi_h1 = iRSI(NULL, PERIOD_H1, 9, PRICE_CLOSE, 0);
   double rsi_m30 = iRSI(NULL, PERIOD_M30, 9, PRICE_CLOSE, 0);
   double rsi_m15 = iRSI(NULL, PERIOD_M15, 9, PRICE_CLOSE, 0);
   double rsi_m5 = iRSI(NULL, PERIOD_M5, 9, PRICE_CLOSE, 0);
   double rsi_m1 = iRSI(NULL, PERIOD_M1, 9, PRICE_CLOSE, 0);
   
   
   double stoc_H4 = iStochastic(NULL, PERIOD_H4, 5,3,3, MODE_EMA, 0, MODE_MAIN, 0);
   double stoc_H1 = iStochastic(NULL, PERIOD_H1, 5,3,3, MODE_EMA, 0, MODE_MAIN, 0);
   double stoc_M30 = iStochastic(NULL, PERIOD_M30, 5,3,3, MODE_EMA, 0, MODE_MAIN, 0);
   double stoc_M15 = iStochastic(NULL, PERIOD_M15, 5,3,3, MODE_EMA, 0, MODE_MAIN, 0);//sto was 15,5,5
   double stoc_M5 = iStochastic(NULL, PERIOD_M5, 5,3,3, MODE_EMA, 0, MODE_MAIN, 0);
   double stoc_M1 = iStochastic(NULL, PERIOD_M1, 5,3,3, MODE_EMA, 0, MODE_MAIN, 0);// was mode signal now gets value off main line
   
   
   double cci_HH4 = iCCI(NULL, PERIOD_H4,13, PRICE_CLOSE, 0);
   double cci_HH1 = iCCI(NULL, PERIOD_H1,13, PRICE_CLOSE, 0); 
   double cci_MM30 = iCCI(NULL, PERIOD_M30,13, PRICE_CLOSE, 0);     
   double cci_MM15 = iCCI(NULL, PERIOD_M15,13, PRICE_CLOSE, 0);    
   double cci_MM5 = iCCI(NULL, PERIOD_M5,13, PRICE_CLOSE, 0);       
   double cci_MM1 = iCCI(NULL, PERIOD_M1,13, PRICE_CLOSE, 0);
   
    
   string STR_h1 = "", STR_m15 = "", STR_m5 = "", STR_m1 = "", STR_h4 ="",STR_m30= "",STR_d1= "",STR_w1= "";
   
   color  color_signal,color_m1,color_m5,color_m15,color_m30,color_m60,color_m240;
  
   if ((rsi_h4 > 50) && (stoc_H4 > 40) && (cci_HH4 > 0)) { STR_h4 = "Buy";color_m240 = Lime;}  //&& (wpr_HHH4 > -50)
   if ((rsi_h1 > 50) && (stoc_H1 > 40) && (cci_HH1 > 0)) { STR_h1 = "Buy";color_m60 = Lime;}
   if ((rsi_m30 > 50) && (stoc_M30 > 40) && (cci_MM30 > 0)) { STR_m30 = "Buy";color_m30 = Lime; }
   if ((rsi_m15 > 50) && (stoc_M15 > 40) && (cci_MM15 > 0)) { STR_m15 = "Buy";color_m15 = Lime; }
   if ((rsi_m5 > 50) && (stoc_M5 > 40) && (cci_MM5 > 0)) { STR_m5 = "Buy"; color_m5 = Lime;}
   if ((rsi_m1 > 50) && (stoc_M1 > 40) && (cci_MM1 > 0)) { STR_m1 = "Buy";  color_m1 = Lime;}
   
  
 
   if ((rsi_h4 < 50) && (stoc_H4 < 60) && (cci_HH4 < 0)) { STR_h4 = "Sell";color_m240 = Red;}
   if ((rsi_h1 < 50) && (stoc_H1 < 60) && (cci_HH1 < 0)) { STR_h1 = "Sell";color_m60 = Red;}
   if ((rsi_m30 < 50) && (stoc_M30 < 60) && (cci_MM30 < 0)) { STR_m30 = "Sell";color_m30 = Red;}
   if ((rsi_m15 < 50) && (stoc_M15 < 60) && (cci_MM15 < 0)) { STR_m15 = "Sell";color_m15 = Red;}
   if ((rsi_m5 < 50) && (stoc_M5 < 60) && (cci_MM5 < 0)) { STR_m5 = "Sell";color_m5 = Red;}
   if ((rsi_m1 < 50) && (stoc_M1 < 60) && (cci_MM1 < 0)) { STR_m1 = "Sell"; color_m1 = Red;}
   
   
   if ((rsi_m1 < 50) && (stoc_M1 > 40) && (cci_MM1 > 0)) { STR_m1 = "Wait";  color_m1 = Orange;}
   if ((rsi_m1 > 50) && (stoc_M1 < 60) && (cci_MM1 < 0)) { STR_m1 = "Wait";  color_m1 = Orange;}
   if ((rsi_m1 < 50) && (stoc_M1 > 40) && (cci_MM1 < 0)) { STR_m1 = "Wait";  color_m1 = Orange;}
   if ((rsi_m1 > 50) && (stoc_M1 < 60) && (cci_MM1 > 0)) { STR_m1 = "Wait";  color_m1 = Orange;}
   if ((rsi_m1 > 50) && (stoc_M1 > 40) && (cci_MM1 < 0)) { STR_m1 = "Wait";  color_m1 = Orange;}  
   if ((rsi_m1 > 50) && (stoc_M1 < 60) && (cci_MM1 < 0)) { STR_m1 = "Wait";  color_m1 = Orange;}
   
   
   if ((rsi_m5 < 50) && (stoc_M5 > 40) && (cci_MM5 > 0)) { STR_m5 = "Wait";  color_m5 = Orange;}
   if ((rsi_m5 > 50) && (stoc_M5 < 60) && (cci_MM5 < 0)) { STR_m5 = "Wait";  color_m5 = Orange;}
   if ((rsi_m5 < 50) && (stoc_M5 > 40) && (cci_MM5 < 0)) { STR_m5 = "Wait";  color_m5 = Orange;}
   if ((rsi_m5 > 50) && (stoc_M5 < 60) && (cci_MM5 > 0)) { STR_m5 = "Wait";  color_m5 = Orange;}
   if ((rsi_m5 > 50) && (stoc_M5 > 40) && (cci_MM5 < 0)) { STR_m5 = "Wait";  color_m5 = Orange;}  
   if ((rsi_m5 > 50) && (stoc_M5 < 60) && (cci_MM5 < 0)) { STR_m5 = "Wait";  color_m5 = Orange;}
   
    if ((rsi_m15 < 50) && (stoc_M15 > 40) && (cci_MM15 > 0)) { STR_m15 = "Wait";  color_m15 = Orange;}
   if ((rsi_m15 > 50) && (stoc_M15 < 60) && (cci_MM15 < 0)) { STR_m15 = "Wait";  color_m15 = Orange;}
   if ((rsi_m15 < 50) && (stoc_M15 > 40) && (cci_MM15 < 0)) { STR_m15 = "Wait";  color_m15 = Orange;}
   if ((rsi_m15 > 50) && (stoc_M15 < 60) && (cci_MM15 > 0)) { STR_m15 = "Wait";  color_m15 = Orange;}
   if ((rsi_m15 > 50) && (stoc_M15 > 40) && (cci_MM15 < 0)) { STR_m15 = "Wait";  color_m15 = Orange;}  
   if ((rsi_m15 > 50) && (stoc_M15 < 60) && (cci_MM15 < 0)) { STR_m15 = "Wait";  color_m15 = Orange;}
      
    if ((rsi_m30 < 50) && (stoc_M30 > 40) && (cci_MM30 > 0)) { STR_m30 = "Wait";  color_m30 = Orange;}
   if ((rsi_m30 > 50) && (stoc_M30 < 60) && (cci_MM30 < 0)) { STR_m30 = "Wait";  color_m30 = Orange;}
   if ((rsi_m30 < 50) && (stoc_M30 > 40) && (cci_MM30 < 0)) { STR_m30 = "Wait";  color_m30 = Orange;}
   if ((rsi_m30 > 50) && (stoc_M30 < 60) && (cci_MM30 > 0)) { STR_m30 = "Wait";  color_m30 = Orange;}
   if ((rsi_m30 > 50) && (stoc_M30 > 40) && (cci_MM30 < 0)) { STR_m30 = "Wait";  color_m30 = Orange;}  
   if ((rsi_m30 > 50) && (stoc_M30 < 60) && (cci_MM30 < 0)) { STR_m30 = "Wait";  color_m30 = Orange;}
   
    if ((rsi_h1 < 50) && (stoc_H1 > 40) && (cci_HH1 > 0)) { STR_h1 = "Wait";  color_m60 = Orange;}
   if ((rsi_h1 > 50) && (stoc_H1 < 60) && (cci_HH1 < 0)) { STR_h1 = "Wait";  color_m60 = Orange;}
   if ((rsi_h1 < 50) && (stoc_H1 > 40) && (cci_HH1 < 0)) { STR_h1 = "Wait";  color_m60 = Orange;}
   if ((rsi_h1 > 50) && (stoc_H1 < 60) && (cci_HH1 > 0)) { STR_h1 = "Wait";  color_m60 = Orange;}
   if ((rsi_h1 > 50) && (stoc_H1 > 40) && (cci_HH1 < 0)) { STR_h1 = "Wait";  color_m60 = Orange;}  
   if ((rsi_h1 > 50) && (stoc_H1 < 60) && (cci_HH1 < 0)) { STR_h1 = "Wait";  color_m60 = Orange;}
   
    if ((rsi_h4 < 50) && (stoc_H4 > 40) && (cci_HH4 > 0)) { STR_h4 = "Wait";  color_m240 = Orange;}
   if ((rsi_h4 > 50) && (stoc_H4 < 60) && (cci_HH4 < 0)) { STR_h4 = "Wait";  color_m240 = Orange;}
   if ((rsi_h4 < 50) && (stoc_H4 > 40) && (cci_HH4 < 0)) { STR_h4 = "Wait";  color_m240 = Orange;}
   if ((rsi_h4 > 50) && (stoc_H4 < 60) && (cci_HH4 > 0)) { STR_h4 = "Wait";  color_m240 = Orange;}
   if ((rsi_h4 > 50) && (stoc_H4 > 40) && (cci_HH4 < 0)) { STR_h4 = "Wait";  color_m240 = Orange;}  
   if ((rsi_h4 > 50) && (stoc_H4 < 60) && (cci_HH4 < 0)) { STR_h4 = "Wait";  color_m240 = Orange;}
   
   
   
                    // Signals                
        
    ObjectCreate("labm1", OBJ_LABEL, WindowFind("STR"), 0, 0);
        ObjectSetText("labm1","M1: ", 15, "Arial Bold", CadetBlue);
        ObjectSet("labm1", OBJPROP_CORNER, 0);
        ObjectSet("labm1", OBJPROP_XDISTANCE, 15);
        ObjectSet("labm1", OBJPROP_YDISTANCE, 15);
        
        ObjectCreate("m1", OBJ_LABEL, WindowFind("STR"), 0, 0);//High value
        ObjectSetText("m1",StringSubstr(STR_m1,0),15, "Arial Bold",  color_m1 );
        ObjectSet("m1", OBJPROP_CORNER, 0);
        ObjectSet("m1", OBJPROP_XDISTANCE, 55);
        ObjectSet("m1", OBJPROP_YDISTANCE, 15);
    
        ObjectCreate("labm5", OBJ_LABEL, WindowFind("STR"), 0, 0);
        ObjectSetText("labm5","M5: ", 15, "Arial Bold", CadetBlue);
        ObjectSet("labm5", OBJPROP_CORNER, 0);
        ObjectSet("labm5", OBJPROP_XDISTANCE, 125);
        ObjectSet("labm5", OBJPROP_YDISTANCE, 15);
        
        ObjectCreate("m5", OBJ_LABEL, WindowFind("STR"), 0, 0);//High value
        ObjectSetText("m5",StringSubstr(STR_m5,0),15, "Arial Bold", color_m5);
        ObjectSet("m5", OBJPROP_CORNER, 0);
        ObjectSet("m5", OBJPROP_XDISTANCE, 165);
        ObjectSet("m5", OBJPROP_YDISTANCE, 15);
   
   ObjectCreate("labm15", OBJ_LABEL, WindowFind("STR"), 0, 0);
        ObjectSetText("labm15","M15: ", 15, "Arial Bold", CadetBlue);
        ObjectSet("labm15", OBJPROP_CORNER, 0);
        ObjectSet("labm15", OBJPROP_XDISTANCE, 235);
        ObjectSet("labm15", OBJPROP_YDISTANCE, 15);
        
        ObjectCreate("m15", OBJ_LABEL, WindowFind("STR"), 0, 0);//High value
        ObjectSetText("m15",StringSubstr(STR_m15,0),15, "Arial Bold",color_m15);
        ObjectSet("m15", OBJPROP_CORNER, 0);
        ObjectSet("m15", OBJPROP_XDISTANCE, 290);
        ObjectSet("m15", OBJPROP_YDISTANCE, 15);
   
   ObjectCreate("labm30", OBJ_LABEL, WindowFind("STR"), 0, 0);
        ObjectSetText("labm30","M30: ", 15, "Arial Bold", CadetBlue);
        ObjectSet("labm30", OBJPROP_CORNER, 0);
        ObjectSet("labm30", OBJPROP_XDISTANCE, 370);
        ObjectSet("labm30", OBJPROP_YDISTANCE, 15);
        
        ObjectCreate("m30", OBJ_LABEL, WindowFind("STR"), 0, 0);//High value
        ObjectSetText("m30",StringSubstr(STR_m30,0),15, "Arial Bold", color_m30);
        ObjectSet("m30", OBJPROP_CORNER, 0);
        ObjectSet("m30", OBJPROP_XDISTANCE, 425);
        ObjectSet("m30", OBJPROP_YDISTANCE, 15);
   
   ObjectCreate("labh1", OBJ_LABEL, WindowFind("STR"), 0, 0);
        ObjectSetText("labh1","H1: ", 15, "Arial Bold", CadetBlue);
        ObjectSet("labh1", OBJPROP_CORNER, 0);
        ObjectSet("labh1", OBJPROP_XDISTANCE, 505);
        ObjectSet("labh1", OBJPROP_YDISTANCE, 15);
        
        ObjectCreate("h1", OBJ_LABEL, WindowFind("STR"), 0, 0);//High value
        ObjectSetText("h1",StringSubstr(STR_h1,0),15, "Arial Bold", color_m60);
        ObjectSet("h1", OBJPROP_CORNER, 0);
        ObjectSet("h1", OBJPROP_XDISTANCE, 545);
        ObjectSet("h1", OBJPROP_YDISTANCE, 15);
   
   ObjectCreate("labh4", OBJ_LABEL, WindowFind("STR"), 0, 0);
        ObjectSetText("labh4","H4: ", 15, "Arial Bold", CadetBlue);
        ObjectSet("labh4", OBJPROP_CORNER, 0);
        ObjectSet("labh4", OBJPROP_XDISTANCE, 625);
        ObjectSet("labh4", OBJPROP_YDISTANCE, 15);
        
        ObjectCreate("h4", OBJ_LABEL, WindowFind("STR"), 0, 0);//High value
        ObjectSetText("h4",StringSubstr(STR_h4,0),15, "Arial Bold", color_m240);
        ObjectSet("h4", OBJPROP_CORNER, 0);
        ObjectSet("h4", OBJPROP_XDISTANCE, 665);
        ObjectSet("h4", OBJPROP_YDISTANCE, 15);


   
                             
//----
   return(0);
  }
//+------------------------------------------------------------------+