//+------------------------------------------------------------------+
//|                                     MaksiGen_KaHaJI_CkaJIneP.mq4 |
//|                                                         MaksiGen |
//|                                                          http:// |
//+------------------------------------------------------------------+
#property copyright "MaksiGen"
#property link      "http://"
//----
#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Orange
#property indicator_color2 Violet
#property indicator_color3 Crimson
#property indicator_color4 Magenta
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
extern string Time_Start_1="08.15";
extern string Time_End_1="11.30";
extern string Time_Start_2="14.00";
extern string Time_End_2="17.30";
extern double Min_Cannel_Width =25;
extern double MaxProfit=10;

//-------------------------------------------------------------------
double val_1[],val_2[],val_3[],val_4[],HighCannel,LowCannel;
string TextHour_Start_1,TextMinute_Start_1,TextHour_End_1,TextMinute_End_1;
string TextHour_Start_2,TextMinute_Start_2,TextHour_End_2,TextMinute_End_2;
string Out;
int Hour_Start_1,Minute_Start_1,Hour_End_1,Minute_End_1;
int Hour_Start_2,Minute_Start_2,Hour_End_2,Minute_End_2;
int Cannel_Width,pr;
bool on_off_trade;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   IndicatorBuffers(4);
   SetIndexStyle(0,DRAW_LINE,1,3);
   SetIndexStyle(1,DRAW_LINE,1,3);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(0,val_1);
   SetIndexBuffer(1,val_2);
   SetIndexBuffer(2,val_3);
   SetIndexBuffer(3,val_4);
//---- Time
   TextHour_Start_1=StringSubstr(Time_Start_1,0,2);Hour_Start_1=StrToInteger(TextHour_Start_1);
   TextMinute_Start_1=StringSubstr(Time_Start_1,3,2);Minute_Start_1=StrToInteger(TextMinute_Start_1);
   TextHour_End_1=StringSubstr(Time_End_1,0,2);Hour_End_1=StrToInteger(TextHour_End_1);
   TextMinute_End_1=StringSubstr(Time_End_1,3,2);Minute_End_1=StrToInteger(TextMinute_End_1);
   TextHour_Start_2=StringSubstr(Time_Start_2,0,2);Hour_Start_2=StrToInteger(TextHour_Start_2);
   TextMinute_Start_2=StringSubstr(Time_Start_2,3,2);Minute_Start_2=StrToInteger(TextMinute_Start_2);
   TextHour_End_2=StringSubstr(Time_End_2,0,2);Hour_End_2=StrToInteger(TextHour_End_2);
   TextMinute_End_2=StringSubstr(Time_End_2,3,2);Minute_End_2=StrToInteger(TextMinute_End_2);
   Comment("");
   if (Point>0.0002) pr=2; else pr=4;
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
  Comment(""); 
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int shift,i,ii;
   int Counted_Bars=IndicatorCounted();
//----
   if (Period()>30)
     {
      if (Minute_Start_1!=0) {Minute_Start_1=0;}
      if (Minute_End_1!=0) {Hour_End_1++;Minute_End_1=0;}
      if (Minute_Start_2!=0) {Minute_Start_2=0;}
      if (Minute_End_2!=0) {Hour_End_2++;Minute_End_2=0;}
     }
//----
   if (Counted_Bars>=Bars) Counted_Bars=Bars;
   if(Counted_Bars<0) return(-1);//---- checking for possible errors
//----
   for(shift=Counted_Bars+10;shift>0;shift--)
     {
      on_off_trade=false;//-estimate trading time
      if (TimeHour(Time[shift])>Hour_Start_1 && TimeHour(Time[shift])<Hour_End_1) on_off_trade=true;
      if (TimeHour(Time[shift])==Hour_Start_1 && TimeMinute(Time[shift])>=Minute_Start_1) on_off_trade=true;
      if (TimeHour(Time[shift])==Hour_End_1 && TimeMinute(Time[shift])<=Minute_End_1) on_off_trade=true;
      if (TimeHour(Time[shift])>Hour_Start_2 && TimeHour(Time[shift])<Hour_End_2) on_off_trade=true;
      if (TimeHour(Time[shift])==Hour_Start_2 && TimeMinute(Time[shift])>=Minute_Start_2) on_off_trade=true;
      if (TimeHour(Time[shift])==Hour_End_2 && TimeMinute(Time[shift])<=Minute_End_2) on_off_trade=true;
      //---
      if (TimeHour(Time[shift])==Hour_Start_1 && TimeMinute(Time[shift])==Minute_Start_1)
        {
         HighCannel=0;
         LowCannel=10000;
//----
         for(i=shift+MathRound((Hour_Start_1*60+Minute_Start_1)/Period());i>shift;i--)
           {
            if (High[i]>HighCannel) HighCannel=High[i];
            if (Low[i]<LowCannel) LowCannel=Low[i];
           }
        }
      //---
      if (on_off_trade)
        {
         val_1[shift]=HighCannel;
         val_3[shift]=HighCannel+MaxProfit*Point;
         val_2[shift]=LowCannel;
         val_4[shift]=LowCannel-MaxProfit*Point;
        }
      Cannel_Width =(HighCannel-LowCannel)/Point;
     }
   if (Cannel_Width>Min_Cannel_Width)
   {Out =", Buy from "+DoubleToStr(HighCannel,pr)+", Sell from "+DoubleToStr(LowCannel,pr);}
   else {Out =", not trading";}
   Comment("\n","Work by ServerTime: from ",TextHour_Start_1,":",TextMinute_Start_1," to ",TextHour_End_1,":",TextMinute_End_1,
   "  and  from ",TextHour_Start_2,":",TextMinute_Start_2," to ",TextHour_End_2,":",TextMinute_End_2,
   "\n","Work Cannel Width:    ",Cannel_Width,Out,
   "\n","Current ServerTime: ",Hour(),":",Minute(),"  Counted Bars: ",Bars,"");
//----
   return(0);
  }
//+------------------------------------------------------------------+

