//+------------------------------------------------------------------+
//| ScreenShots.mq4 version 2.1                      iziogas@mail.com|
//+------------------------------------------------------------------+

#property indicator_chart_window

//---- input parameters
extern string identification="ScreenShot";
extern int size.x=1024;
extern int size.y=768;

string fYear() {
   return (TimeYear(Time[0]));
}
  
string fMonth() {
   int i;
   i = TimeMonth(Time[0]);
   if (i<10) return ("0"+i); else return (i); 
}

string fDay() {
   int i;
   i = TimeDay(Time[0]);
   if (i<10) return ("0"+i); else return (i); 
}

string fHour() {
   int i;
   i = TimeHour(Time[0]);
   if (i<10) return ("0"+i); else return (i); 
}

string fMinute() {
   int i;
   i = TimeMinute(Time[0]);
   if (i<10) return ("0"+i); else return (i); 
}

string fSeconds() {
   int i;
   i = TimeSeconds(Time[0]);
   if (i<10) return ("0"+i); else return (i); 
}





int start()
  {
   static datetime OpenTime=0;
   static bool TakeShot = false;
   datetime CurrentTime;
   string dir;

   if (!TakeShot) {
      //check for new bar
      CurrentTime = iTime(NULL,0,0);
      if (OpenTime==CurrentTime) return(0);
      OpenTime=CurrentTime;
      TakeShot = True;
      return(0);
   }
   TakeShot = False;
   
   dir = StringConcatenate(identification,"\\",Symbol(),"\\",Period(),"\\",fYear(),fMonth(),fDay(),"\\");
   
   ScreenShot(
      StringConcatenate(dir,
                        identification,".",
                        Symbol(),".",
                        Period(),".",
                        fYear(),fMonth(),fDay(),".",
                        fHour(),fMinute(),fSeconds(),
                        ".gif"),size.x,size.y);
 

   return(0);
  }

 


