
#property copyright "Sam Jesse"
#property link      "phddas@yahoo.com"

#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 2

//------- flexable settings
extern int    NumberOfDays = 50; 
extern string NY_start           = "10:00";
extern string NY_end             = "19:00";
extern color  NY_color           = Gold;
extern string London_start       = "15:00";
extern string London_end         = "23:59";
extern color  London_color       = Blue;
extern string Sydney_start       = "00:00";
extern string Sydney_end         = "09:00";
extern color  Sydney_color       = Green;
extern string Tokyo_start        = "03:00";
extern string Tokyo_end          = "12:00";
extern color  Tokyo_color        = Brown;




//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void init() {
  DeleteObjects();
  for (int i=0; i<NumberOfDays; i++) {
    CreateObjects("PWT1"+i, NY_color);
    CreateObjects("PWT2"+i, London_color);
    CreateObjects("PWT3"+i, Sydney_color);
    CreateObjects("PWT4"+i, Tokyo_color);    
  }
  Comment("");
}

//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
void deinit() {
  DeleteObjects();
  Comment("");
}

//+------------------------------------------------------------------+
//                                                                   |
//+------------------------------------------------------------------+
void CreateObjects(string no, color cl) {
  ObjectCreate(no, OBJ_RECTANGLE, 1, 0,0, 0,0);
  ObjectSet(no, OBJPROP_STYLE, STYLE_SOLID);
  ObjectSet(no, OBJPROP_COLOR, cl);
  ObjectSet(no, OBJPROP_BACK, True);
}


void DeleteObjects() {
  for (int i=0; i<NumberOfDays; i++) {
    ObjectDelete("PWT1"+i);
    ObjectDelete("PWT2"+i);
    ObjectDelete("PWT3"+i);
    ObjectDelete("PWT4"+i);
  }
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
void start() {
  datetime dt=CurTime();

  for (int i=0; i<NumberOfDays; i++) {
    DrawObjects(dt, "PWT1"+i, NY_start, NY_end, 0, 1);
    DrawObjects(dt, "PWT2"+i, London_start, London_end, 1, 2);
    DrawObjects(dt, "PWT3"+i, Sydney_start, Sydney_end, 0, 1);
    DrawObjects(dt, "PWT4"+i, Tokyo_start, Tokyo_end, 1, 2);
    dt=decDateTradeDay(dt);
    while (TimeDayOfWeek(dt)>5) dt=decDateTradeDay(dt);
  }
}


void DrawObjects(datetime dt, string no, string tb, string te, int a, int b) {
  datetime t1, t2;
  t1=StrToTime(TimeToStr(dt, TIME_DATE)+" "+tb);
  t2=StrToTime(TimeToStr(dt, TIME_DATE)+" "+te);
  ObjectSet(no, OBJPROP_TIME1 , t1);
  ObjectSet(no, OBJPROP_PRICE1, a);
  ObjectSet(no, OBJPROP_TIME2 , t2);
  ObjectSet(no, OBJPROP_PRICE2, b);
}

/* param @ an epoch
   return @ an epoch of the same time one day prior
*/
datetime decDateTradeDay (datetime dt) {
  int ty=TimeYear(dt);
  int tm=TimeMonth(dt);
  int td=TimeDay(dt);
  int th=TimeHour(dt);
  int ti=TimeMinute(dt);

  td--;
  if (td==0) {
    tm--;
    if (tm==0) {
      ty--;
      tm=12;
    }
    if (tm==1 || tm==3 || tm==5 || tm==7 || tm==8 || tm==10 || tm==12) td=31;
    if (tm==2) if (MathMod(ty, 4)==0) td=29; else td=28;
    if (tm==4 || tm==6 || tm==9 || tm==11) td=30;
  }
  return(StrToTime(ty+"."+tm+"."+td+" "+th+":"+ti));
}
//+------------------------------------------------------------------+

