//+------------------------------------------------------------------+
//|                                           Set_Fibo_Price_Any.mq4 |
//|                              Copyright  2007, Eng. Waddah Attar |
//|                                          waddahattar@hotmail.com |
//|                                                                  |
//| 2007.02.16  V1 original by waddhattar                            |
//| 2007.10.31  V2 by pips4life                                      |
//+------------------------------------------------------------------+
//
// This handy indicator adds price info to Fibo Retrracement and Expansion
//   levels on your chart.  For example:  "61.8" becomes  "61.8  234.67"
//   (compact format "2"), or instead, "(61.8) - 234.67" (original format "1").
//
//  Version history for Set_Fibo_Price_Any:
//  2007.02.16 V1 (waddahattar)  Original release.  Downloaded from:
//     http://codebase.mql4.com/1003
//  2007.10.31 V2 (pips4life, http://forexfactory.com):
//   - Added Fib Expansion objects
//   - Added TextStyle property to give user a choice of the 
//        original format, or a slightly more compact description
//
//
// Instructions:
//   Copy this mq4 file into directory:
//      C:\Program Files\_your_MT4_name_here\experts\indicators\
//   Open the file using MetaEditor
//   Change the TextStyle default if desired. See below for description
//   Compile the file.  This will create the .ex4 file in the same directory.
//   Add the indicator to your chart.  All Fibo Retracement or Expansion
//      objects you have, or that you add to the chart later, will 
//      automatically show the price as well as the level
//     (Note: Prices will show after the first new tick).
//   It so happens that when you add Fibo objects to new charts, you *may*
//     not need to add this indicator to every chart, because it essentially
//     creates a new default for the fibo objects.  However, existing Fibo
//     ojects may still have the old format until you specifically add this
//     indicator to that chart (or delete the chart and start over).  Safest
//     would be to just add it to every chart, but this is not always 
//     necessary, and it might waste a bit of CPU to do so.  Experiment for
//     yourself.
//
//   FYI, the "_Any" in the name refers to the fact that you can add
//      any custom fibo level (e.g. 85.4) and this version will still add
//      the price to that level.  A previous version only worked with the
//      standard default fibo levels; hence "_Any" was added to the name. 
//


#property copyright "Copyright Waddah Attar"
#property link      "waddahattar@hotmail.com"
//----
#property indicator_chart_window

extern int TextStyle = 2 ;
//   0 = Plain format.  no prices:  61.8
//   1 = Waddah's original style:  (61.8) - 234.67
//   2 = compact style:   61.8  234.67


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
  {
   Comment("Set_Fibo_Price_Any_V2");
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int deinit()
  {
   int obj_total = ObjectsTotal();
   int i, j;
   string name;
   for(i = 0; i < obj_total; i++)
     {
       name = ObjectName(i);
       if(ObjectType(name) == OBJ_FIBO)
         {
          for( j=0 ; j<32 ; j++ )
            { 
              if(GetLastError() != 0) 
                break;
              ObjectSetFiboDescription(name, j, DoubleToStr(ObjectGet(name, 
                                       OBJPROP_FIRSTLEVEL + j)*100, 1));
            }
         }
         else if(ObjectType(name) == OBJ_EXPANSION)
         {
          for( j=0 ; j<32 ; j++ )
            {
              if(GetLastError() != 0) 
                break;
              ObjectSetFiboDescription(name, j, "FE " + DoubleToStr(ObjectGet(name, 
                                       OBJPROP_FIRSTLEVEL + j)*100, 1));
            }
         } 
     }
   Comment("");
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   int    obj_total = ObjectsTotal();
   string name,text;
   int i, j;
   for(i = 0; i < obj_total; i++)
     {
       name = ObjectName(i);
       if(ObjectType(name) == OBJ_FIBO)
         {
           for(j = 0; j < 32; j++)
             {
               if(GetLastError() != 0) 
                 break;
               switch (TextStyle)
               {
                 case 2 :
                   // Style 2 example is:  61.8  234.67
                   ObjectSetFiboDescription(name, j, DoubleToStr(ObjectGet(name,
                                        OBJPROP_FIRSTLEVEL+j)*100,1) + "  %$");
                   break;
                 case 0 :
                   // Style 0 example is:  61.8
                   ObjectSetFiboDescription(name, j, DoubleToStr(ObjectGet(name,
                                        OBJPROP_FIRSTLEVEL+j)*100,1));
                   break;
                 default:
                   // default, or style 1.  Example:  (61.8) - 234.67
                   ObjectSetFiboDescription(name, j, "(" + DoubleToStr(ObjectGet(name,
                                        OBJPROP_FIRSTLEVEL+j)*100,1) + ")" + " - %$");
               }
             }
         } else if(ObjectType(name) == OBJ_EXPANSION)
         {
           for(j = 0; j < 32; j++)
             {
               if(GetLastError() != 0) 
                 break;
               switch (TextStyle)
               {
                 case 2 :
                   // Style 2 example is:  FE 61.8  234.67
                   ObjectSetFiboDescription(name, j, "FE " + DoubleToStr(ObjectGet(name,
                                        OBJPROP_FIRSTLEVEL+j)*100,1) + "  %$");
                   break;
                 case 0 :
                   // Style 0 example is:  FE 61.8
                   ObjectSetFiboDescription(name, j, "FE " + DoubleToStr(ObjectGet(name,
                                        OBJPROP_FIRSTLEVEL+j)*100,1));
                   break;
                 default:
                   // default, or style 1.  Example:  FE (61.8) - 234.67
                   ObjectSetFiboDescription(name, j, "FE (" + DoubleToStr(ObjectGet(name,
                                        OBJPROP_FIRSTLEVEL+j)*100,1) + ")" + " - %$");
               }
             }
         }
     }
//----   
   return(0);
  }
//+------------------------------------------------------------------+


