//+------------------------------------------------------------------+
//|                                                  Silver MACD.mq4 |
//|                                           Copyright  2004, Viac |
//|                                              http://www.viac.ru/ |
//|                              modified by maumax AKA Foreverold   |
//|                              to change color,signal lines were   |
//|                              there, but  did not show until more |
//|                               colors were added                  |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2004, Viac.ru"
#property  link      "http://www.viac.ru/"

//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 6
#property  indicator_color1  ForestGreen
#property  indicator_color2  Red
#property indicator_color3 Lime
#property indicator_color4 Yellow
#property indicator_color5 IndianRed
#property indicator_color6 LightGreen



//---- indicator parameters
extern int FastEMA=9;
extern int SlowEMA=26;
extern int SignalSMA=9;
extern int Price=PRICE_WEIGHTED;
extern int Mode=MODE_EMA;


//---- indicator buffers
double green_buffer[];
double red_buffer[];
double MACD[];
double Signal[];
double IRB[];
double LGB[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
   IndicatorBuffers(6);
   SetIndexStyle(0,DRAW_HISTOGRAM,0,2);
   SetIndexBuffer(0,green_buffer);
//----
   SetIndexStyle(1,DRAW_HISTOGRAM,0,2);
   SetIndexBuffer(1,red_buffer);

   SetIndexBuffer(2,MACD);
   SetIndexBuffer(3,Signal);
   
   SetIndexStyle(4,DRAW_HISTOGRAM,0,2);
   SetIndexBuffer(4,IRB);
  
   
   SetIndexStyle(5,DRAW_HISTOGRAM,0,2);
   SetIndexBuffer(5,LGB);
   


//---- sets drawing line empty value
   SetIndexEmptyValue(0, 0.0);
   SetIndexEmptyValue(1, 0.0);       
   SetIndexEmptyValue(2, 0.0);
   SetIndexEmptyValue(3, 0.0);
   SetIndexEmptyValue(4, 0.0); 
   SetIndexEmptyValue(5, 0.0);    
//----
   IndicatorDigits(Digits+1);
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("SilverMACD("+FastEMA+","+SlowEMA+","+SignalSMA+")");
   SetIndexLabel(0,"GreenMACD");      
   SetIndexLabel(1,"RedMACD");
   SetIndexLabel(2,"IndianRedMACD");
   SetIndexLabel(3,"LightGreenMACD");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Moving Averages Convergence/Divergence                           |
//+------------------------------------------------------------------+
int start()
  {
   int limit;   
   int counted_bars=IndicatorCounted();
   int i;
//---- check for possible errors
   if(counted_bars<0) return(-1);
//
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
   Print("limit=",limit);
   if (counted_bars==0) limit=Bars-SlowEMA;
//----   MACD
   for(i=0; i<limit; i++)
      MACD[i]=iMA(NULL,0,FastEMA,0,Mode,Price,i)-iMA(NULL,0,SlowEMA,0,Mode,Price,i);
//----     MACD
//----We calculate signal line for MACD


   for(i=0; i<limit; i++)
      Signal[i]=iMAOnArray(MACD,0,SignalSMA,0,MODE_SMA,i);
//---- If MACD more or is equal signal, then the green otherwise red


   for (i=0; i<limit; i++) 
   {
      if (MACD[i] >= Signal[i]) 
      {
        green_buffer[i] = MACD[i];
        IRB[i]=0.0;
        red_buffer[i] = 0.0;
      //  IRB[i]=0.0;
      }
      else 
      {
        green_buffer[i] = 0.0;
        LGB[i]=0.0;
        red_buffer[i] = MACD[i];
        
      }
   }
   return(0);
  }

