//+------------------------------------------------------------------+
//|                                                        SmCCI.mq4 |
//|                      Copyright  2006, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_separate_window
#property indicator_buffers 3
#property indicator_color1 LightSeaGreen
#property indicator_color2 YellowGreen
#property indicator_color3 Wheat
//---- input parameters
extern int       t3_period=4;
extern double    b=0.7;
extern int       per=14;
extern int       applied_price=0;
//---- buffers
double ADXBuffer[];
double PlusDiBuffer[];
double MinusDiBuffer[];
double e1, e2, e3, e4, e5, e6, c1, c2, c3, c4, n, w1, w2, b2, b3;
double adx, dtp, dtm, t3;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ADXBuffer);
   SetIndexLabel(0,"ADX");
   SetIndexStyle(1,DRAW_LINE, STYLE_DOT);
   SetIndexBuffer(1,PlusDiBuffer);
   SetIndexLabel(1,"+DI");   
   SetIndexStyle(2,DRAW_LINE, STYLE_DOT);
   SetIndexBuffer(2,MinusDiBuffer);
   SetIndexLabel(2,"-DI");   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
      b2=b*b;
      b3=b2*b;
      c1=-b3;
      c2=(3*(b2+b3));
      c3=-3*(2*b2+b+b3);
      c4=(1+3*b+b3+3*b2);
      n=t3_period;

      if (n<1) {n=1;}
      n = 1 + 0.5*(n-1);
      w1 = 2 / (n + 1);
      w2 = 1 - w1;

   for(int shift=Bars-1; shift>=0; shift--)
   {
      ADXBuffer[shift]=0;
      PlusDiBuffer[shift]=0;
      MinusDiBuffer[shift]=0;

      dtp=iADX(NULL, 0, per, applied_price, MODE_PLUSDI, shift);
      e1 = w1*dtp + w2*e1;
      e2 = w1*e1 + w2*e2;
      e3 = w1*e2 + w2*e3;
      e4 = w1*e3 + w2*e4;
      e5 = w1*e4 + w2*e5;
      e6 = w1*e5 + w2*e6;
      t3 = c1*e6 + c2*e5 + c3*e4 + c4*e3;
      PlusDiBuffer[shift] =t3; e1=0;
      
      dtm=iADX(NULL, 0, per, applied_price, MODE_MINUSDI, shift);            
      e1 = w1*dtm + w2*e1;
      e2 = w1*e1 + w2*e2;
      e3 = w1*e2 + w2*e3;
      e4 = w1*e3 + w2*e4;
      e5 = w1*e4 + w2*e5;
      e6 = w1*e5 + w2*e6;
      t3 = c1*e6 + c2*e5 + c3*e4 + c4*e3;
      MinusDiBuffer[shift]=t3; e1=0;
      
      adx=iADX(NULL, 0, per, applied_price, MODE_MAIN, shift);      
      e1 = w1*adx + w2*e1;
      e2 = w1*e1 + w2*e2;
      e3 = w1*e2 + w2*e3;
      e4 = w1*e3 + w2*e4;
      e5 = w1*e4 + w2*e5;
      e6 = w1*e5 + w2*e6;
      t3 = c1*e6 + c2*e5 + c3*e4 + c4*e3;
      ADXBuffer[shift]=t3; e1=0;
   }
   
   return(0);
  }
//+------------------------------------------------------------------+