//+------------------------------------------------------------------+
//|                                                        SmATR.mq4 |
//|                                                       MetaQuotes |
//|                 http://forum.alpari-idc.ru/viewtopic.php?t=48186 |
//+------------------------------------------------------------------+
#property copyright "MetaQuotes"
#property link      "http://forum.alpari-idc.ru/viewtopic.php?t=48186"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Gold

//---- input parameters
extern double    t3_period=8.0;
extern int       AtrPeriod=14;
extern double    b=0.7;

//---- buffers
double ExtMapBuffer1[];

double e1Buffer[];
double e2Buffer[];
double e3Buffer[];
double e4Buffer[];
double e5Buffer[];
double e6Buffer[];

double /*e1,e2,e3,e4,e5,e6,*/c1,c2,c3,c4,n,w1,w2,b2,b3;
double dpo,t3,ATR;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
     string short_name;
//---- indicators
   IndicatorBuffers(8);

   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);

   SetIndexBuffer(2,e1Buffer);
   SetIndexBuffer(3,e2Buffer);
   SetIndexBuffer(4,e3Buffer);
   SetIndexBuffer(5,e4Buffer);
   SetIndexBuffer(6,e5Buffer);
   SetIndexBuffer(7,e6Buffer);
   
   SetIndexEmptyValue(0,0.0);
   SetIndexEmptyValue(1,0.0);
   SetIndexEmptyValue(2,0.0);
   SetIndexEmptyValue(3,0.0);
   SetIndexEmptyValue(4,0.0);
   SetIndexEmptyValue(5,0.0);
   SetIndexEmptyValue(6,0.0);
   SetIndexEmptyValue(7,0.0);
   
   //---- name for DataWindow and indicator subwindow label
   short_name="SmATR("+AtrPeriod+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,short_name);
   
   //----
   b2=b*b;
   b3=b2*b;
   c1=-b3;
   c2=(3*(b2+b3));
   c3=-3*(2*b2+b+b3);
   c4=(1+3*b+b3+3*b2);
   n=t3_period;

   if(n<1) n=1;
   n = 1 + 0.5*(n-1);
   w1 = 2 / (n + 1);
   w2 = 1 - w1;

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
   int shift,limit;
   if (counted_bars==0) limit=Bars-AtrPeriod;
   if (counted_bars>=0) limit=Bars-counted_bars;
   limit--;

   for (shift=limit;shift>=0;shift--)
      {//Begin
   
      ATR=iATR(NULL,0,AtrPeriod,shift);
      dpo=ATR;
      e1Buffer[shift] = w1*dpo + w2*e1Buffer[shift+1];
      e2Buffer[shift] = w1*e1Buffer[shift] + w2*e2Buffer[shift+1];
      e3Buffer[shift] = w1*e2Buffer[shift] + w2*e3Buffer[shift+1];
      e4Buffer[shift] = w1*e3Buffer[shift] + w2*e4Buffer[shift+1];
      e5Buffer[shift] = w1*e4Buffer[shift] + w2*e5Buffer[shift+1];
      e6Buffer[shift] = w1*e5Buffer[shift] + w2*e6Buffer[shift+1];

      t3 = c1*e6Buffer[shift] + c2*e5Buffer[shift] + c3*e4Buffer[shift] + c4*e3Buffer[shift];

      if (t3==0) t3=0.0001;

      ExtMapBuffer1[shift]=t3;  
   }
   return(0);
  }
//+------------------------------------------------------------------+


