//+------------------------------------------------------------------+
//|                                                    SnapShotI.mq4 |
//|                                     Copyright  2006, MQLService |
//|                                        http://www.mqlservice.com |
//| $Id: //depot/mt4files/experts/indicators/SnapShotI.mq4#6 $
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, MQLService"
#property link      "http://www.mqlservice.com"
#include <stdlib.mqh>

#property indicator_chart_window

extern int  DelayTicks  = 1; // Delay so many ticks after new bar
extern int  ShotsPerBar = 1; // How many screen shots per bar
extern bool ShowLabel   = true; // Displays text in down left corner

#define LABEL "SnapShotILabel"

int init()
{
  ShowLabel();
  return(0);
}

int deinit()
{
  HideLabel();
  return(0);
}

void ShowLabel()
{
  if(!ShowLabel) return;
  if(!ObjectCreate(LABEL, OBJ_LABEL, 0, 0, 0))
    Print("Error: can't create label object! ", ErrorDescription(GetLastError()));
  ObjectSet(LABEL, OBJPROP_CORNER, 2);
  ObjectSet(LABEL, OBJPROP_XDISTANCE, 4);
  ObjectSet(LABEL, OBJPROP_YDISTANCE, 2);
  ObjectSetText(LABEL, "SnapShotI is active ("+DelayTicks+","+ShotsPerBar+")", 8, "Arial", Yellow);
}

void HideLabel()
{
  if(!ShowLabel) return;
  if(!ObjectDelete(LABEL))
    Print("Error deleting label: ", ErrorDescription(GetLastError()));
}

int start(){
   static datetime last_bar;
   static int DoShot    = -1;
   static int old_phase = 3000000;
   
   if(ShotsPerBar > 0)
     int shot_interval = MathRound((60*Period())/ShotsPerBar);
   else
     shot_interval = 60*Period();
   int phase = MathFloor((CurTime()-Time[0])/shot_interval);
   
   if(Time[0] != last_bar){
     last_bar = Time[0];
     DoShot = DelayTicks;
   }else if(phase > old_phase)
     MakeScreenShot("i");
   old_phase = phase;

   if(DoShot == 0) MakeScreenShot();
   if(DoShot >= 0) DoShot -= 1;

   return(0);
}

string al0(int number, int digits){
  // add leading zeros that the resulting string has 'digits' length.
  string result;
  result = DoubleToStr(number, 0);
  while(StringLen(result)<digits) result = "0"+result;
  return(result);
}

void MakeScreenShot(string sx=""){
  static int no=0;
  no++;
  string fn = "SnapShot"+Symbol()+Period()+"\\"+Year()+"-"+al0(Month(),2)+"-"+al0(Day(),2)+" "+
              al0(Hour(),2)+"_"+al0(Minute(),2)+"_"+al0(Seconds(),2)+" "+no+sx+".gif";
  HideLabel();
  if(!ScreenShot(fn,640,480)) Print("ScreenShot error: ", ErrorDescription(GetLastError()));
  ShowLabel();
}

//+---- Programmed by Michal Rutka -----------------------------------------+