//+------------------------------------------------------------------+
//|                                            StepMA_sashken_v2.mq4 |
//|                                          E-mail: sashken@mail.ru |
//+------------------------------------------------------------------+

#property link      "E-mail: sashken@mail.ru"

#property indicator_chart_window
#property indicator_buffers 7
#property indicator_color1 Aqua
#property indicator_color2 Gold
#property indicator_color3 Red
#property indicator_color4 Lime
#property indicator_color5 Magenta

//---- input parameters
extern int MA=5;                    // ma period
extern int MAmode=MODE_EMA;         // ma mode
extern int MAprice=PRICE_CLOSE;     // ma price
extern double StepSizeFast=0.0015;  // points
extern double StepSizeSlow=0.0015;  // points
extern int FastSdvig=3;  //
extern int SlowSdvig=3;  //
extern int StepSmooth=1;  //

extern double StepSize=2.0;         // 2.0
extern int TotalBar=5000;           
//extern int HighLow=0;
//---- indicator buffers
double Line1Buffer[];
double Line2Buffer[];
double Line3Buffer[];
double Line4Buffer[];
double Line5Buffer[];
double Line6Buffer[];
double Line7Buffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
  int init()
  {
   string short_name;
//---- indicator line
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,1);
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,2);
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,2);
   SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,2);
   SetIndexStyle(3,DRAW_ARROW,STYLE_SOLID,2);
   SetIndexStyle(4,DRAW_ARROW,STYLE_SOLID,2);
   SetIndexStyle(5,DRAW_NONE);
   SetIndexStyle(6,DRAW_NONE);
   SetIndexEmptyValue(3,0);
   SetIndexArrow(3,233);
   SetIndexEmptyValue(4,0);
   SetIndexArrow(4,234);
   SetIndexBuffer(0,Line1Buffer);
   SetIndexBuffer(1,Line2Buffer);
   SetIndexBuffer(2,Line3Buffer);
   SetIndexBuffer(3,Line4Buffer);
   SetIndexBuffer(4,Line5Buffer);
   SetIndexBuffer(5,Line6Buffer);
   SetIndexBuffer(6,Line7Buffer);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
//---- name for DataWindow and indicator subwindow label
   short_name="StepMA_sashken(Period:"+MA+", Fast:"+StepSizeFast+", Slow:"+StepSizeSlow+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,"MA");
   SetIndexLabel(1,"StepMA fast");
   SetIndexLabel(2,"StepMA slow");
   SetIndexLabel(3,"UP signal");
   SetIndexLabel(4,"DOWN signal");
//----
   SetIndexDrawBegin(0,1);
   SetIndexDrawBegin(1,1);
   SetIndexDrawBegin(2,1);
//----
   return(0);
  }

//+------------------------------------------------------------------+
//| StepMA_sashken_v1                                                |
//+------------------------------------------------------------------+
int start()
  {
   int shift,ftrend,strend;
   double fmin0,fmax0,fmin1,fmax1,smin0,smax0,smin1,smax1,MA0;
   if (TotalBar==0) {TotalBar=Bars-1;}
   
   for(shift=TotalBar;shift>=0;shift--)
   {	
   MA0=iMA(NULL,0,MA,0,MAmode,MAprice,shift);
   
	  fmax0=MA0+StepSize*StepSizeFast;
	  fmin0=MA0-StepSize*StepSizeFast;
	  	    
	  if (MA0>fmax1)  ftrend=1; 
	  if (MA0<fmin1)  ftrend=-1;

	  if(ftrend>0 && fmin0<fmin1) fmin0=fmin1;
	  if(ftrend<0 && fmax0>fmax1) fmax0=fmax1;
	  
	  smax0=MA0+StepSize*StepSizeSlow;
	  smin0=MA0-StepSize*StepSizeSlow;
		
	  if (MA0>smax1)  strend=1; 
	  if (MA0<smin1)  strend=-1;

	  if(strend>0 && smin0<smin1) smin0=smin1;
	  if(strend<0 && smax0>smax1) smax0=smax1;
	    
	  
	  Line1Buffer[shift]=MA0;
	  
	  if (ftrend>0) Line6Buffer[shift-FastSdvig]=fmin0+StepSizeFast;
	  if (ftrend<0) Line6Buffer[shift-FastSdvig]=fmax0-StepSizeFast;
	  
	  if (strend>0) Line7Buffer[shift-SlowSdvig]=smin0+StepSizeSlow;
	  if (strend<0) Line7Buffer[shift-SlowSdvig]=smax0-StepSizeSlow;
	  
	  fmin1=fmin0;
	  fmax1=fmax0;
	  smin1=smin0;
	  smax1=smax0;
	 }
	 
	 
	 
	 	for(shift=TotalBar;shift>=0;shift--)
      {	
      Line2Buffer[shift]= iMAOnArray(Line6Buffer,0,StepSmooth,0,MODE_EMA,shift);
      Line3Buffer[shift]= iMAOnArray(Line7Buffer,0,StepSmooth,0,MODE_EMA,shift);
      }
	 
	 
	 
	 
	 
	 
	 
	 
	 for(shift=TotalBar;shift>=0;shift--)
   {	
	  if (Line2Buffer[shift+1]>Line3Buffer[shift+1] && Line2Buffer[shift+2]<=Line3Buffer[shift+2])
	     {
	     Line4Buffer[shift] = Line3Buffer[shift+1]-StepSizeFast;
	     }
	  if (Line2Buffer[shift+1]<Line3Buffer[shift+1] && Line2Buffer[shift+2]>=Line3Buffer[shift+2])
	     {
	     Line5Buffer[shift] = Line3Buffer[shift+1]+StepSizeFast;
	     }
	  
	 }
	 
	return(0);	
 }

