//+------------------------------------------------------------------+
//|                                                    StepMA_v6.mq4 |
//|                           Copyright  2005, TrendLaboratory Ltd. |
//|                                       E-mail: igorad2004@list.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, TrendLaboratory Ltd."
#property link      "E-mail: igorad2004@list.ru"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 LightBlue
#property indicator_color2 Blue
#property indicator_color3 Red
//---- input parameters
extern int     Length=10;      // ATR Length
extern double  Kv=1.0;         // Sensivity Factor
extern int     StepSize=0;     // Constant Step Size (if need)
extern int     Advance=0;      // Offset
extern bool    HighLow=false;  // High/Low Mode Switch (more sensitive)
extern bool    Color=false;    // Color Mode Switch   
//---- indicator buffers
double LineBuffer[];
double UpBuffer[];
double DnBuffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
  int init()
  {
   string short_name;
//---- indicator line
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,1);
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexStyle(2,DRAW_ARROW);
   SetIndexArrow(1,159);
   SetIndexArrow(2,159);
   SetIndexShift(0,Advance);
   SetIndexShift(1,Advance);
   SetIndexShift(2,Advance);
   SetIndexBuffer(0,LineBuffer);
   SetIndexBuffer(1,UpBuffer);
   SetIndexBuffer(2,DnBuffer);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
//---- name for DataWindow and indicator subwindow label
   short_name="StepMA("+StepSize+","+Kv+","+StepSize+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,short_name);
   SetIndexLabel(1,"UpTrend");
   SetIndexLabel(2,"DownTrend"); 
//----
   SetIndexDrawBegin(0,Length);
   SetIndexDrawBegin(1,Length);
   SetIndexDrawBegin(2,Length);
//----
   return(0);
  }

//+------------------------------------------------------------------+
//| StepMA_v6                                                         |
//+------------------------------------------------------------------+
int start()
  {
   int i,shift,trend,Step;
   double smin0,smax0,smin1,smax1,ATRmin=10000,ATRmax=0;
	
   
   for(shift=Bars-1;shift>=0;shift--) LineBuffer[shift]=0.0;	
    
   
   for(shift=Bars-1-Length;shift>=0;shift--)
   {	
	
	ATRmax=MathMax(iATR(NULL,0,Length,shift),ATRmax);
	ATRmin=MathMin(iATR(NULL,0,Length,shift),ATRmin);
	 
	if( StepSize>0 ) 
	{Step=StepSize;}
	else
	{Step=0.5*Kv*(ATRmax+ATRmin)/Point;} 
		
	Comment (" StepSize= ", Step);
	if (HighLow)
	  {
	  smax0=Low[shift]+2.0*Step*Point;
	  smin0=High[shift]-2.0*Step*Point;
     } 	
	else  	 
	  {
	  smax0=Close[shift]+2.0*Step*Point;
	  smin0=Close[shift]-2.0*Step*Point;
	  }
	  
	  if (Close[shift]>smax1)  trend=1; 
	  if (Close[shift]<smin1)  trend=-1;
	  
	  if(trend>0)
	  {
	  if(smin0<smin1) smin0=smin1;
	  LineBuffer[shift]=smin0+Step*Point;
	  if(Color) UpBuffer[shift]=smin0+Step*Point; 
	  } 
	  else
	  {
	  if(smax0>smax1) smax0=smax1;
	  LineBuffer[shift]=smax0-Step*Point;
	  if(Color) DnBuffer[shift]=smax0-Step*Point; 
	  }
	  smin1=smin0;
	  smax1=smax0;
	 }
	return(0);	
 }


