//based on divergence indicators created by FX5, hazem@uk2.net
//modified by U.D.C., udc@seznam.cz
//----
#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_buffers 4
#property indicator_color1 Lime
#property indicator_color2 Red
#property indicator_color3 Magenta
#property indicator_color4 White
//---- input parameters
extern string separator1 = "*** Sto Settings ***";
extern int    StoPeriod=14;
extern int    DPeriod=3;
extern int    Slowing=3;
extern string separator2 = "*** Indicator Settings ***";
extern bool   divergenceDetector = true;
extern bool   drawIndicatorTrendLines = true;
extern bool   drawPriceTrendLines = false;
extern bool   displayAlert = true;
extern bool   displayLabel = true;
extern int    arrowsDisplacement = 5;
extern string separator3 = "* If labels are disabled, corresponding";
extern string separator4 = "* WindowNumber must be set.";
extern string separator5 = "* (Indicator windows are numbered";
extern string separator6 = "* from up, first WindowNumber is 1.}";
extern int    WindowNumber = 0;
//---- buffers
double bullishDivergence[];
double bearishDivergence[];
double sto[];
double sig[];
//----
static datetime lastAlertTime;
static string   indicatorName;
string signalName;
int draw_begin1=0;
int draw_begin2=0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0, DRAW_ARROW);
   SetIndexStyle(1, DRAW_ARROW);
   SetIndexStyle(2, DRAW_LINE);
   SetIndexStyle(3, DRAW_LINE);
//----   
   SetIndexBuffer(0, bullishDivergence);
   SetIndexBuffer(1, bearishDivergence);
   SetIndexBuffer(2, sto);
   SetIndexBuffer(3, sig);
//----   
   SetIndexArrow(0, 233);
   SetIndexArrow(1, 234);
//----

   if(displayLabel == true)
      {
      indicatorName = "Sto_Div("+StoPeriod+","+DPeriod+","+Slowing+")";
      signalName = "Signal";
      }
   else
      {
      indicatorName = "";
      signalName = "";
      }
   IndicatorShortName(indicatorName);
   SetIndexLabel(2,indicatorName);
   SetIndexLabel(3,signalName);
   draw_begin1=StoPeriod+Slowing;
   draw_begin2=draw_begin1+DPeriod;
   SetIndexDrawBegin(2,draw_begin1);
   SetIndexDrawBegin(3,draw_begin2);

   return(0);
}
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   for(int i = ObjectsTotal() - 1; i >= 0; i--)
     {
       string label = ObjectName(i);
       if(StringSubstr(label, 0, 19) == "Sto_DivergenceLine")
           ObjectDelete(label);   
     }
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int countedBars = IndicatorCounted();
   if(countedBars < 0)
       countedBars = 0;
   CalculateIndicator(countedBars);
//---- 
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalculateIndicator(int countedBars)
  {
   for(int i = Bars - countedBars; i >= 0; i--)
     {
       CalculateSto(i);
       if(divergenceDetector == true)
       {
         CatchBullishDivergence(i + 2);
         CatchBearishDivergence(i + 2);
       }
     }              
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalculateSto(int i)
  {
   sto[i] = iStochastic(NULL, 0, StoPeriod, DPeriod, Slowing, MODE_SMA, PRICE_CLOSE, MODE_MAIN, i);
   sig[i] = iStochastic(NULL, 0, StoPeriod, DPeriod, Slowing, MODE_SMA, PRICE_CLOSE, MODE_SIGNAL, i);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CatchBullishDivergence(int shift)
  {
   if(IsIndicatorTrough(shift) == false)
       return;  
   int currentTrough = shift;
   int lastTrough = GetIndicatorLastTrough(shift);
   if(sto[currentTrough] > sto[lastTrough] && Low[currentTrough] < Low[lastTrough])
     {
       bullishDivergence[currentTrough] = sto[currentTrough] - arrowsDisplacement;

       if(drawPriceTrendLines == true)
           DrawPriceTrendLine(Time[currentTrough], Time[lastTrough], Low[currentTrough], 
                             Low[lastTrough], Green, STYLE_SOLID);

       if(drawIndicatorTrendLines == true)
          DrawIndicatorTrendLine(Time[currentTrough], Time[lastTrough], sto[currentTrough],
                                 sto[lastTrough], Green, STYLE_SOLID);

       if(displayAlert == true)
          DisplayAlert("Sto Classic BULL diverg.: ", currentTrough);  
     }
   if(sto[currentTrough] < sto[lastTrough] && Low[currentTrough] > Low[lastTrough])
     {
       bullishDivergence[currentTrough] = sto[currentTrough] - arrowsDisplacement;

       if(drawPriceTrendLines == true)
           DrawPriceTrendLine(Time[currentTrough], Time[lastTrough], Low[currentTrough], 
                              Low[lastTrough], Green, STYLE_DOT);

       if(drawIndicatorTrendLines == true)                            
           DrawIndicatorTrendLine(Time[currentTrough], Time[lastTrough], sto[currentTrough],
                                  sto[lastTrough], Green, STYLE_DOT);

       if(displayAlert == true)
           DisplayAlert("Sto Reverse BULL diverg.: ", currentTrough);   
     }      
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CatchBearishDivergence(int shift)
  {
   if(IsIndicatorPeak(shift) == false)
       return;
   int currentPeak = shift;
   int lastPeak = GetIndicatorLastPeak(shift);

   if(sto[currentPeak] < sto[lastPeak] && High[currentPeak] > High[lastPeak])
     {
       bearishDivergence[currentPeak] = sto[currentPeak] + arrowsDisplacement;
      
       if(drawPriceTrendLines == true)
           DrawPriceTrendLine(Time[currentPeak], Time[lastPeak], High[currentPeak], 
                              High[lastPeak], Red, STYLE_SOLID);
                            
       if(drawIndicatorTrendLines == true)
           DrawIndicatorTrendLine(Time[currentPeak], Time[lastPeak], sto[currentPeak],
                                  sto[lastPeak], Red, STYLE_SOLID);

       if(displayAlert == true)
           DisplayAlert("Sto Classic BEAR diverg.: ", currentPeak);  
     }
   if(sto[currentPeak] > sto[lastPeak] && High[currentPeak] < High[lastPeak])
     {
       bearishDivergence[currentPeak] = sto[currentPeak] + arrowsDisplacement;

       if(drawPriceTrendLines == true)
           DrawPriceTrendLine(Time[currentPeak], Time[lastPeak], High[currentPeak], 
                              High[lastPeak], Red, STYLE_DOT);

       if(drawIndicatorTrendLines == true)
           DrawIndicatorTrendLine(Time[currentPeak], Time[lastPeak], sto[currentPeak],
                                  sto[lastPeak], Red, STYLE_DOT);

       if(displayAlert == true)
           DisplayAlert("Sto Reverse BEAR diverg.: ", currentPeak);   
     }   
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool IsIndicatorPeak(int shift)
  {
   if(sto[shift] >= sto[shift+1] && sto[shift] > sto[shift+2] && 
      sto[shift] > sto[shift-1])
       return(true);
   else 
       return(false);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool IsIndicatorTrough(int shift)
  {
   if(sto[shift] <= sto[shift+1] && sto[shift] < sto[shift+2] && 
      sto[shift] < sto[shift-1])
       return(true);
   else 
       return(false);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int GetIndicatorLastPeak(int shift)
  {
   for(int i = shift + 5; i < Bars; i++)
     {
       if(sig[i] >= sig[i+1] && sig[i] >= sig[i+2] &&
          sig[i] >= sig[i-1] && sig[i] >= sig[i-2])
         {
           for(int j = i; j < Bars; j++)
             {
               if(sto[j] >= sto[j+1] && sto[j] > sto[j+2] &&
                  sto[j] >= sto[j-1] && sto[j] > sto[j-2])
                   return(j);
             }
         }
     }
   return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int GetIndicatorLastTrough(int shift)
  {
    for(int i = shift + 5; i < Bars; i++)
      {
        if(sig[i] <= sig[i+1] && sig[i] <= sig[i+2] &&
           sig[i] <= sig[i-1] && sig[i] <= sig[i-2])
          {
            for (int j = i; j < Bars; j++)
              {
                if(sto[j] <= sto[j+1] && sto[j] < sto[j+2] &&
                   sto[j] <= sto[j-1] && sto[j] < sto[j-2])
                    return(j);
              }
          }
      }
    return(-1);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void DisplayAlert(string message, int shift)
  {
   if(shift <= 2 && Time[shift] != lastAlertTime)
     {
       lastAlertTime = Time[shift];
       Alert(message, Symbol(), " , ", Period(), " min. chart");
     }
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void DrawPriceTrendLine(datetime x1, datetime x2, double y1, 
                        double y2, color lineColor, double style)
  {
   string label = "Sto_DivergenceLine_v1.0# " + DoubleToStr(x1, 0);
   ObjectDelete(label);
   ObjectCreate(label, OBJ_TREND, 0, x1, y1, x2, y2, 0, 0);
   ObjectSet(label, OBJPROP_RAY, 0);
   ObjectSet(label, OBJPROP_COLOR, lineColor);
   ObjectSet(label, OBJPROP_STYLE, style);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void DrawIndicatorTrendLine(datetime x1, datetime x2, double y1, 
                            double y2, color lineColor, double style)
  {

   if(displayLabel == true)
   {
      int indicatorWindow = WindowFind(indicatorName);
      if(indicatorWindow < 0)
         return;
   }
   else indicatorWindow=WindowNumber;

   string label = "Sto_DivergenceLine_v1.0$# " + DoubleToStr(x1, 0);
   ObjectDelete(label);
   ObjectCreate(label, OBJ_TREND, indicatorWindow, x1, y1, x2, y2, 
                0, 0);
   ObjectSet(label, OBJPROP_RAY, 0);
   ObjectSet(label, OBJPROP_COLOR, lineColor);
   ObjectSet(label, OBJPROP_STYLE, style);
  }
//+------------------------------------------------------------------+



