//+------------------------------------------------------------------+
//|                                               StochColorBars.mq4 |
//|                                      Copyright  2004-35, banzai |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004-35, banzai"
#property link      "http://www.forex-tsd.com/indicators-metatrader-4/4108-stochastic-color-bar.html"

#property indicator_separate_window
#property indicator_buffers   4
#property  indicator_minimum 0
#property  indicator_maximum 1
#property indicator_color1 Lime //Uptrend
#property indicator_color2 Red //Downtrend
#property indicator_color3 DarkGreen //Overbought
#property indicator_color4 Maroon //Oversold
 
//extern string note1 = "Chart Time Frame";
//extern string note2 = "0=current time frame";
//extern string note3 = "1=M1, 5=M5, 15=M15, 30=M30";
//extern string note4 = "60=H1, 240=H4, 1440=D1";
//extern string note5 = "10080=W1, 43200=MN1";
int	TimeFrame	= 0;		// {1=M1, 5=M5, 15=M15, ..., 1440=D1, 10080=W1, 43200=MN1}
extern string note6 = "Stochastic settings";
extern int       KPeriod     =  14;
extern int       DPeriod     =  3;
extern int       Slowing     =  3;
extern string note7 = "0=sma, 1=ema, 2=smma, 3=lwma";
extern int       MAMethod    =   0;
extern string note8 = "0=high/low, 1=close/close";
extern int       PriceField  =   1;
extern string note9 = "overbought level";
extern int       overBought  =  80;
extern string note10 = "oversold level";
extern int       overSold    =  20;

double Uptrend[];
double Downtrend[];
double Upper[];
double Lower[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

int init()
{
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,4,indicator_color1);
   SetIndexBuffer(0,Uptrend);
   SetIndexLabel(0,"Uptrend");
   
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,4,indicator_color2);
   SetIndexBuffer(1,Downtrend);
   SetIndexLabel(1,"Downtrend");
   
   SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID,4,indicator_color3);
   SetIndexBuffer(2,Upper);
   SetIndexLabel(2,"Upper");   
   SetIndexStyle(3,DRAW_HISTOGRAM,STYLE_SOLID,4,indicator_color4);
   SetIndexBuffer(3,Lower);
   SetIndexLabel(3,"Lower");          
         
   IndicatorShortName("StochBars ("+KPeriod+","+DPeriod+","+Slowing+")");
   return(0);
}

int deinit()
{
   return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

int start()
{
   int    counted_bars=IndicatorCounted(), limit, banzai;
   double percentK, percentD;
   
   if(counted_bars<0) return(-1);
   limit=Bars-counted_bars;
      
   for(banzai=limit; banzai>=0; banzai--)
      {
            percentK = iStochastic(NULL,TimeFrame,KPeriod,DPeriod,Slowing,MAMethod,PriceField,MODE_MAIN,banzai);
            percentD = iStochastic(NULL,TimeFrame,KPeriod,DPeriod,Slowing,MAMethod,PriceField,MODE_SIGNAL,banzai);
            if (percentK >= percentD)   { Uptrend[banzai]   = 1;}
            if (percentK <= percentD)   { Downtrend[banzai] = 1;}
            if (percentK >= overBought) { Upper[banzai]     = 1;}
            if (percentK <= overSold)   { Lower[banzai]     = 1;}                   
      }
 
   return(0);
}


