//+------------------------------------------------------------------+
//|                StochCrossStrength.mq4                            |
//|                Copyright  2006  Scorpion@fxfisherman.com        |
//+------------------------------------------------------------------+
#property copyright "FxFisherman.com"
#property link      "http://www.fxfisherman.com"
#property indicator_chart_window
#property indicator_buffers 1

#include <WinUser32.mqh>

extern string Sound1 = "alert.wav";
extern string Sound2 = "alert2.wav";

extern int Stoch_K = 11;
extern int Stoch_D = 3;
extern int Stoch_Slowing = 3;

//---- buffers
double v1[];

  
int init()
  {

   IndicatorBuffers(1);
   SetIndexDrawBegin(0,-1);
   SetIndexBuffer(0, v1);
   SetIndexLabel(0,"Buy");
   
   watermark();

   return(0);
  }

int start()
 {  
  // Calculate values
  double stochk0 = iStochastic(Symbol(), Period(), Stoch_K,Stoch_D, Stoch_Slowing, MODE_SMA, 0, MODE_MAIN, 0);
  double stochd0 = iStochastic(Symbol(), Period(), Stoch_K,Stoch_D, Stoch_Slowing, MODE_SMA, 0, MODE_SIGNAL, 0);
  double stochk1 = iStochastic(Symbol(), Period(), Stoch_K,Stoch_D, Stoch_Slowing, MODE_SMA, 0, MODE_MAIN, 1);
  double stochd1 = iStochastic(Symbol(), Period(), Stoch_K,Stoch_D, Stoch_Slowing, MODE_SMA, 0, MODE_SIGNAL, 1);
  int strength = 100 - (MathAbs(stochk0-stochd0)*5);
  if (strength<0) strength=0;
  
  // Output
  static datetime last_cross;
  if (last_cross != Time[0])
  {
    if (stochk1 <= stochd1 && stochk0 > stochd0 && stochk0<=30)
    {
      last_cross = Time[0];
      PlaySound(Sound1);
      Alert("Stoch crosses up!");
    }else if(stochk1 >= stochd1 && stochk0 < stochd0 && stochk0>=70){
      PlaySound(Sound2);
      Alert("Stoch crosses down!");
    }
  }
    
  return(0);
 }
 
 
void watermark()
  {
   ObjectCreate("fxfisherman", OBJ_LABEL, 0, 0, 0);
   ObjectSetText("fxfisherman", "fxfisherman.com", 11, "Lucida Handwriting", Black);
   ObjectSet("fxfisherman", OBJPROP_CORNER, 2);
   ObjectSet("fxfisherman", OBJPROP_XDISTANCE, 5);
   ObjectSet("fxfisherman", OBJPROP_YDISTANCE, 10);
   return(0);
  }
 
//+------------------------------------------------------------------+


