//+------------------------------------------------------------------+
//|                                               StochThreshold.mq4 |
//|                                   2007 by  wibitiens - ForexTSD |
//|                                                                  |
//+------------------------------------------------------------------+
#property  copyright " 2007, wibitiens"
#property  link      "http://www.com/"

//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 3
#property  indicator_color1  Lime
#property  indicator_color2  Red
#property  indicator_width1  2
#property  indicator_width2  2

//---- indicator parameters
extern   int   UpperLimit  = 80;
extern   int   LowerLimit  = 20;
extern   int   LevelSpace  = 15;
extern   int   StoK     = 5;
extern   int   StoD     = 3;
extern   int   StoSlow  = 3;

//---- indicator buffers
double   UpBuffer[], LowBuffer[];
int      i;

int init()
  {
   SetIndexStyle(0,DRAW_HISTOGRAM);
   IndicatorDigits(Digits+1);
   SetIndexBuffer(0,UpBuffer);

   SetIndexStyle(1,DRAW_HISTOGRAM);
   IndicatorDigits(Digits+1);
   SetIndexBuffer(1,LowBuffer);

   return(0);
  }

int start()
  {
   double STO1_I, STO1_II, STO1_III;
   
   for(i=Bars; i>=0; i--)
   {
      
      STO1_I    = iStochastic(NULL,15,StoK,StoD,StoSlow,MODE_SMA,0,MODE_MAIN,i);
      STO1_II   = iStochastic(NULL,30,StoK,StoD,StoSlow,MODE_SMA,0,MODE_MAIN,i);
      STO1_III  = iStochastic(NULL,60,StoK,StoD,StoSlow,MODE_SMA,0,MODE_MAIN,i);
      
      UpBuffer[i]       = 0;
      LowBuffer[i]      = 0;
      
      if ((STO1_I>UpperLimit-LevelSpace*0)&&(STO1_II>UpperLimit-LevelSpace*1)&&
                                 (STO1_III>UpperLimit-LevelSpace*2)) 
               UpBuffer[i] = 1;
               
      else if ((STO1_I<LowerLimit+LevelSpace*0)&&(STO1_II<LowerLimit+LevelSpace*1)&&
                                      (STO1_III<LowerLimit+LevelSpace*2)) 
               LowBuffer[i] = 1;
      else
      {
         if (UpBuffer[i+1]==1)  UpBuffer[i]=1;
         if (LowBuffer[i+1]==1) LowBuffer[i]=1;
      }
   }   
                    
   IndicatorShortName("StochThreshold - %K="+ StoK+ ", %D="+ StoD+ ", Slowing="+ StoSlow);
   return(0);
  }
  

