//+------------------------------------------------------------------+
//|                                         iStochTxt(komposter).mq4 |
//|                                      Copyright  2006, komposter |
//|                                      mailto:komposterius@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, komposter"
#property link      "mailto:komposterius@mail.ru"
//----
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Lime
#property indicator_color2 Red
#property indicator_width1 1
#property indicator_width2 1
//----
extern int		k				= 5;
extern int		s				= 1;
extern int		l				= 50;
extern bool		text			= false;
extern color	text_color	= Yellow;
extern bool		alert			= false;
//----
double BuyBuffer[], SellBuffer[];
int pre_signal = 0;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
  {
	  IndicatorShortName("iStochTxt");
//----
	  SetIndexBuffer(0, BuyBuffer);
	  SetIndexLabel(0, "Buy");
	  SetIndexStyle(0, DRAW_ARROW, STYLE_SOLID, 1);
	  SetIndexArrow(0, 241);
//----
	  SetIndexBuffer(1, SellBuffer);
	  SetIndexLabel(1, "Sell");
	  SetIndexStyle(1, DRAW_ARROW, STYLE_SOLID, 1);
	  SetIndexArrow(1, 242);
//----
	  return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int deinit()
  {
	  if(text)
	    {
		     for(int i = 0; i < ObjectsTotal(); i++)
		       {
			        if(StringFind( ObjectName(i), "txt_", 0 ) == 0)
			          {
				           ObjectDelete(ObjectName(i));
				           i--;
			          }
		       }
	    }
	  return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
	  int counted_bars = IndicatorCounted();
//----
	  if(counted_bars < 0) 
	    { 
	      Print("Indicator Error (Counted bars < 0)!"); 
	      return(-1); 
	    }
//----
	  if(Bars < 17) 
	    { 
	      Print("Indicator Error (Bars < 12)!" ); 
	      return(-1); 
	    }
   int limit = Bars - 17;
//----
   if(counted_bars > 17) 
     { 
       limit = Bars - counted_bars; 
     }
//----
	  for(int i = limit; i >= 0; i --)
	    {
		     BuyBuffer[i] = EMPTY_VALUE;
		     SellBuffer[i] = EMPTY_VALUE;      
		     //----
       double mc = iStochastic(NULL, 0, k, 3, s, 0, 0, MODE_MAIN, i);
		     double mp = iStochastic(NULL, 0, k, 3, s, 0, 0, MODE_MAIN, i+1);
		     //----
       if(mc > l && mp <= l)
		       {
			        BuyBuffer[i] = Low[i] - iATR(NULL, 0, 14, i);
			        if(text) 
			          { 
			            create_text(i, Low[i] - 1.5*iATR(NULL, 0, 14, i )); 
			          }
		       }
		     if(mc < 100-l && mp >= 100-l)
		       {
			        SellBuffer[i] = High[i] + iATR(NULL, 0, 14, i);         
			        if(text) 
			          { 
			            create_text(i, High[i] + 1.5*iATR( NULL, 0, 14, i)); 
			          }
		       }
	    }
	  if(alert)
	    {
		     if(pre_signal <= 0 && BuyBuffer [1] != EMPTY_VALUE) 
		       { 
		         Alert("iStochTxt( ", Symbol(), ", ", Period(), " ) - BUY!"); 
		         pre_signal =  1; 
		       }
		     if(pre_signal >= 0 && SellBuffer[1] != EMPTY_VALUE) 
		       { 
		         Alert("iStochTxt( ", Symbol(), ", ", Period(), " ) - SELL!"); 
		         pre_signal = -1; 
		       }
	    }
	  return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void create_text(int u, double p)
  {
	  string name = "txt_" + Time[u];
	  ObjectDelete(name);
	  ObjectCreate(name, OBJ_TEXT, 0, Time[u], p);
	  ObjectSetText(name, DoubleToStr( Close[u], Digits ) + " " + TimeToStr( Time[u], 
	                TIME_MINUTES), 8, "Arial", text_color);
  }
//+------------------------------------------------------------------+