//+------------------------------------------------------------------+
//|                                                   Stochastic.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net/"

#property indicator_separate_window

#property indicator_buffers 2
#property indicator_color1 LightSeaGreen
#property indicator_color2 Red
#property indicator_level1 80//76.4 //
#property indicator_level2 70//61.8
#property indicator_level3 50.0
#property indicator_level4 30//38.2
#property indicator_level5 20//23.6  //
#property indicator_maximum	100
#property indicator_minimum	0
#property indicator_levelcolor  DarkSlateGray
//---- input parameters
extern string Sound1 = "alert.wav";
extern string Sound2 = "alert.wav";
extern int KPeriod=5;
extern int DPeriod=3;
extern int Slowing=3;
extern int OSLevel=30;
extern int OBLevel=70;
//---- buffers
double MainBuffer[];
double SignalBuffer[];
double HighesBuffer[];
double LowesBuffer[];
//----
int draw_begin1=0;
int draw_begin2=0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   string short_name;
//---- 2 additional buffers are used for counting.
   IndicatorBuffers(4);
   SetIndexBuffer(2, HighesBuffer);
   SetIndexBuffer(3, LowesBuffer);
//---- indicator lines
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0, MainBuffer);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1, SignalBuffer);
//---- name for DataWindow and indicator subwindow label
   short_name="Sto("+KPeriod+","+DPeriod+","+Slowing+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,short_name);
   SetIndexLabel(1,"Signal");
//----
   draw_begin1=KPeriod+Slowing;
   draw_begin2=draw_begin1+DPeriod;
   SetIndexDrawBegin(0,draw_begin1);
   SetIndexDrawBegin(1,draw_begin2);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Stochastic oscillator                                            |
//+------------------------------------------------------------------+
int start()
  {
   int    i,k;
   int    counted_bars=IndicatorCounted();
   double price;
//----
   if(Bars<=draw_begin2) return(0);
//---- initial zero
   if(counted_bars<1)
     {
      for(i=1;i<=draw_begin1;i++) MainBuffer[Bars-i]=0;
      for(i=1;i<=draw_begin2;i++) SignalBuffer[Bars-i]=0;
     }
//---- minimums counting
   i=Bars-KPeriod;
   if(counted_bars>KPeriod) i=Bars-counted_bars-1;
   while(i>=0)
     {
      double min=1000000;
      k=i+KPeriod-1;
      while(k>=i)
        {
         price=Low[k];
         if(min>price) min=price;
         k--;
        }
      LowesBuffer[i]=min;
      i--;
     }
//---- maximums counting
   i=Bars-KPeriod;
   if(counted_bars>KPeriod) i=Bars-counted_bars-1;
   while(i>=0)
     {
      double max=-1000000;
      k=i+KPeriod-1;
      while(k>=i)
        {
         price=High[k];
         if(max<price) max=price;
         k--;
        }
      HighesBuffer[i]=max;
      i--;
     }
//---- %K line
   i=Bars-draw_begin1;
   if(counted_bars>draw_begin1) i=Bars-counted_bars-1;
   while(i>=0)
     {
      double sumlow=0.0;
      double sumhigh=0.0;
      for(k=(i+Slowing-1);k>=i;k--)
        {
         sumlow+=Close[k]-LowesBuffer[k];
         sumhigh+=HighesBuffer[k]-LowesBuffer[k];
        }
      if(sumhigh==0.0) MainBuffer[i]=100.0;
      else MainBuffer[i]=sumlow/sumhigh*100;
      i--;
     }
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   int limit=Bars-counted_bars;

//---- signal line is simple movimg average
   for(i=0; i<limit; i++)
      SignalBuffer[i]=iMAOnArray(MainBuffer,Bars,DPeriod,0,MODE_SMA,i);
//----ALERT-----------------------------------------------------
{  
  // Calculate values
  double stochk0 = iStochastic(Symbol(), Period(), KPeriod,DPeriod,Slowing, MODE_SMA, 0, MODE_MAIN, 0);
  double stochd0 = iStochastic(Symbol(), Period(), KPeriod,DPeriod,Slowing, MODE_SMA, 0, MODE_SIGNAL, 0);
  double stochk1 = iStochastic(Symbol(), Period(), KPeriod,DPeriod,Slowing, MODE_SMA, 0, MODE_MAIN, 1);
  double stochd1 = iStochastic(Symbol(), Period(), KPeriod,DPeriod,Slowing, MODE_SMA, 0, MODE_SIGNAL, 1);
 string short_name;
 short_name ="Sto("+KPeriod+","+DPeriod+","+Slowing+")";
 
  
  // Output
  static datetime last_cross;
  if (last_cross == Time[0]){
         return(0);
      }
  {
    if (stochk1 <= stochd1 && stochk0 > stochd0 && stochd0<=OSLevel)
    {
      //last_cross = Time[0];
      PlaySound(Sound1);
      Alert(Symbol(),"Stoch("+short_name+") Crossing UP!(OSL"+OSLevel+"");
    }else if(stochk1 >= stochd1 && stochk0 < stochd0 && stochd0>=OBLevel){
      PlaySound(Sound2);
      Alert(Symbol(),"Stoch ("+short_name+") Crossing Down!(OBL"+OBLevel+"");
    }
  }
last_cross = Time[0];
   return(0);
  }
  }
//+------------------------------------------------------------------+