//+------------------------------------------------------------------+
//|                                                StochasticRSI.mq4 |
//|                                                           mladen |
//+------------------------------------------------------------------+
#define IndicatorFileName "StochasticRSI"
#property copyright "mladen"
#property link      ""

#property indicator_separate_window
#property indicator_buffers 6
#property indicator_color1  DimGray
#property indicator_color2  DimGray
#property indicator_color3  DimGray
#property indicator_color4  DimGray
#property indicator_color5  Red
#property indicator_color6  LimeGreen
#property indicator_width4  2
#property indicator_width5  2
#property indicator_width6  2
#property indicator_style1  STYLE_DOT
#property indicator_style2  STYLE_DOT
#property indicator_style3  STYLE_DOT

//
//
//
//
//

extern int    StochPeriod      =  34;
extern int    RSIPeriod        =   8;
extern int    RSIPrice         =   0;
extern int    SmoothingPeriod  =  10;
extern int    SmoothingMethod  =   0;
extern int    BandsPeriod      =  20;
extern double BandsDeviation   = 2.0;
extern bool   ShowBands        = true;
extern string timeFrame = "Current time frame";

//
//
//
//
//

double BandsBuffer1[];
double BandsBuffer2[];
double BandsBuffer3[];
double StochRSIBuffer[];
double Upper[];
double Lower[];
double RSIBuffer[];
double StochBuffer[];

//
//
//
//
//

int      TimeFrame;
datetime TimeArray[];


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

int init()
{
   IndicatorBuffers(8);
      SetIndexBuffer(0,BandsBuffer1);
      SetIndexBuffer(1,BandsBuffer2);
      SetIndexBuffer(2,BandsBuffer3);
      SetIndexBuffer(3,StochRSIBuffer);
      SetIndexBuffer(4,Upper);
      SetIndexBuffer(5,Lower);
      SetIndexBuffer(6,RSIBuffer);
      SetIndexBuffer(7,StochBuffer);
      
      //
      //
      //
      //
      //
      
         if (ShowBands)
            {
               SetIndexStyle(0,DRAW_LINE);
               SetIndexStyle(1,DRAW_LINE);
               SetIndexStyle(2,DRAW_LINE);
               SetIndexLabel(0,"StochRSI midle band");
               SetIndexLabel(1,"StochRSI upper band");
               SetIndexLabel(2,"StochRSI lower band");
            }
         else
            {
               SetIndexStyle(0,DRAW_NONE);
               SetIndexStyle(1,DRAW_NONE);
               SetIndexStyle(2,DRAW_NONE);
               SetIndexLabel(0,NULL);
               SetIndexLabel(1,NULL);
               SetIndexLabel(2,NULL);
            }

      //
      //
      //
      //
      //
      
      SetIndexLabel(3,"StochRSI");
      SetIndexLabel(4,NULL);
      SetIndexLabel(5,NULL);
      
      //
      //
      //
      //
      //
      
   TimeFrame  = stringToTimeFrame(timeFrame); CheckMTF(TimeFrame);
   IndicatorShortName("StochasticRSI."+TimeFrameToString(TimeFrame)+" ("+StochPeriod+","+RSIPeriod+","+SmoothingPeriod+")");
   return(0);
}
int deinit()
{
   return(0);
}

//
//
//
//
//

void CheckMTF(int& tf)
{
   string glbName = "CheckingStochasticRSI";
   double TestValue;

   //
   //
   //
   //
   //
   
   if (TimeFrame != Period())
   {
      GlobalVariableSet(glbName,0.0);
      TestValue = iCustom(NULL,tf,IndicatorFileName,3,0);
         if (GlobalVariableGet(glbName)==0.0)
         {
            Alert("Switching to NO MTF mode");
            Alert(IndicatorFileName+" indicator renamed or missing from indicators directory");
            tf = Period();
         }
   }            
   
   //
   //
   //
   //
   //
   
   GlobalVariableSet(glbName,1.0);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

int start()
{
   int      counted_bars=IndicatorCounted();
   int      limit,i,k;
   double   deviation;
   double   sum;
   double   high;
   double   low;
   int      error;
   

   if(counted_bars < 0) return(-1);
   if(counted_bars>0) counted_bars--;
         limit = Bars-counted_bars;


   //
   //
   //
   //
   //
   
   if (TimeFrame != Period())
      {
         limit = MathMax(limit,TimeFrame/Period());
            ArrayCopySeries(TimeArray ,MODE_TIME ,NULL,TimeFrame);
         
            //
            //
            //
            //
            //
         
            for(i=0,int y=0; i<limit; i++) {
               if(Time[i]<TimeArray[y]) y++;
                  StochRSIBuffer[i] = iCustom(NULL,TimeFrame,IndicatorFileName,3,y);
                  Upper[i]          = iCustom(NULL,TimeFrame,IndicatorFileName,4,y);
                  Lower[i]          = iCustom(NULL,TimeFrame,IndicatorFileName,5,y);
                  if (ShowBands)
                     {
                        BandsBuffer1[i]   = iCustom(NULL,TimeFrame,IndicatorFileName,0,y);
                        BandsBuffer2[i]   = iCustom(NULL,TimeFrame,IndicatorFileName,1,y);
                        BandsBuffer3[i]   = iCustom(NULL,TimeFrame,IndicatorFileName,2,y);
                     }                        
            }
         return(0);         
      }

   //
   //
   //
   //
   //

      for (i=limit;i>=0;i--)
      {
         RSIBuffer[i] = iRSI(NULL,0,RSIPeriod,RSIPrice,i);

         //
         //
         //
         //
         //

         high =       0.00;
         low  = 9999999.99;
         for (k=0; k<StochPeriod; k++) {
            if (high < RSIBuffer[i+k]) high = RSIBuffer[i+k];
            if (low  > RSIBuffer[i+k]) low  = RSIBuffer[i+k];
         }
         if (high!=low)
               StochBuffer[i] = (RSIBuffer[i] - low)/(high-low);
         else  StochBuffer[i] = 0;
      }
      for (i=limit;i>=0;i--) StochRSIBuffer[i] = iMAOnArray(StochBuffer,0,SmoothingPeriod,0,SmoothingMethod,i)*100.0;
      for (i=limit;i>=0;i--)
      {
         BandsBuffer1[i] = iMAOnArray(StochRSIBuffer,0,BandsPeriod,0,MODE_SMA ,i);

         for (k=0,sum = 0; k<BandsPeriod; k++)  sum += MathPow(StochRSIBuffer[i+k]-BandsBuffer1[i],2.0);
               deviation       = BandsDeviation*MathSqrt(sum/BandsPeriod);
               BandsBuffer2[i] = BandsBuffer1[i]+deviation;
               BandsBuffer3[i] = BandsBuffer1[i]-deviation;

         //
         //
         //
         //
         //
                                    
         if (StochRSIBuffer[i] > BandsBuffer2[i]) { Upper[i] = StochRSIBuffer[i]; Upper[i+1] = StochRSIBuffer[i+1]; }
         else                                     { Upper[i] = EMPTY_VALUE;
                                                     if (Upper[i+2] == EMPTY_VALUE)
                                                         Upper[i+1]  = EMPTY_VALUE; }
         if (StochRSIBuffer[i] < BandsBuffer3[i]) { Lower[i] = StochRSIBuffer[i]; Lower[i+1] = StochRSIBuffer[i+1]; }
         else                                     { Lower[i] = EMPTY_VALUE;
                                                     if (Lower[i+2] == EMPTY_VALUE)
                                                         Lower[i+1]  = EMPTY_VALUE; }
      }      
      
   //
   //
   //
   //
   //
   
   return(0);
}


//+------------------------------------------------------------------+
//|
//+------------------------------------------------------------------+

int stringToTimeFrame(string tfs)
{
   int tf=0;
       tfs = StringTrimLeft(StringTrimRight(StringUpperCase(tfs)));
         if (tfs=="M1" || tfs=="1")     tf=PERIOD_M1;
         if (tfs=="M5" || tfs=="5")     tf=PERIOD_M5;
         if (tfs=="M15"|| tfs=="15")    tf=PERIOD_M15;
         if (tfs=="M30"|| tfs=="30")    tf=PERIOD_M30;
         if (tfs=="H1" || tfs=="60")    tf=PERIOD_H1;
         if (tfs=="H4" || tfs=="240")   tf=PERIOD_H4;
         if (tfs=="D1" || tfs=="1440")  tf=PERIOD_D1;
         if (tfs=="W1" || tfs=="10080") tf=PERIOD_W1;
         if (tfs=="MN" || tfs=="43200") tf=PERIOD_MN1;
         if (tf<Period()) tf=Period();
  return(tf);
}
string TimeFrameToString(int tf)
{
   string tfs="Current time frame";
   switch(tf) {
      case PERIOD_M1:  tfs="M1"  ; break;
      case PERIOD_M5:  tfs="M5"  ; break;
      case PERIOD_M15: tfs="M15" ; break;
      case PERIOD_M30: tfs="M30" ; break;
      case PERIOD_H1:  tfs="H1"  ; break;
      case PERIOD_H4:  tfs="H4"  ; break;
      case PERIOD_D1:  tfs="D1"  ; break;
      case PERIOD_W1:  tfs="W1"  ; break;
      case PERIOD_MN1: tfs="MN1";
   }
   return(tfs);
}

//
//
//
//
//

string StringUpperCase(string str)
{
   string   s = str;
   int      lenght = StringLen(str) - 1;
   int      char;
   
   while(lenght >= 0)
      {
         char = StringGetChar(s, lenght);
         
         //
         //
         //
         //
         //
         
         if((char > 96 && char < 123) || (char > 223 && char < 256))
                  s = StringSetChar(s, lenght, char - 32);
         else 
              if(char > -33 && char < 0)
                  s = StringSetChar(s, lenght, char + 224);
         lenght--;
   }
   
   //
   //
   //
   //
   //
   
   return(s);
}