//+------------------------------------------------------------------+
//|                                                Super8 Filter.mq4 |
//|                      Copyright  2004, MetaQuotes Software Corp. |
//|                                       http://www.metaquotes.net/ |
//+------------------------------------------------------------------+
#property  copyright "Copyright  2004, MetaQuotes Software Corp."
#property  link      "http://www.metaquotes.net/"
//---- indicator settings
#property indicator_separate_window
#property indicator_minimum -0.05
#property indicator_maximum 1.05
#property indicator_buffers 4

#property indicator_color1 MediumBlue
#property indicator_color2 LightBlue
#property indicator_color3 Orange
#property indicator_color4 Crimson

//---- indicator parameters


//---- indicator buffers
double UpBuffer1[];
double UpBuffer2[];
double UpBuffer3[];
double UpBuffer4[];
double ind_buffer1[];
double ind_buffer2[];


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(6);
//---- drawing settings
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexStyle(3,DRAW_HISTOGRAM,STYLE_SOLID,2);

   SetIndexBuffer(0,UpBuffer1);
   SetIndexBuffer(1,UpBuffer2);
   SetIndexBuffer(2,UpBuffer3);
   SetIndexBuffer(3,UpBuffer4);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS)+2);

   SetIndexBuffer(4,ind_buffer1);
   SetIndexBuffer(5,ind_buffer2);
     
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("Super 8 Filter");
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Moving Average of Oscillator                                     |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int trend;
   double current,current1,prev,prev1;
   int counted_bars=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;
//---- macd counted in the 1-st additional buffer
   for(int i=0; i<limit; i++)
      ind_buffer1[i]=iMA(NULL,0,12,0,MODE_EMA,PRICE_CLOSE,i)-iMA(NULL,0,26,0,MODE_EMA,PRICE_CLOSE,i);
//---- signal line counted in the 2-nd additional buffer
   for(i=0; i<limit; i++)
      ind_buffer2[i]=iMA(NULL,0,15,0,MODE_EMA,PRICE_CLOSE,i)-iMA(NULL,0,102,0,MODE_EMA,PRICE_CLOSE,i);

   
   for(i=limit-1; i>=0; i--)
     {
      UpBuffer1[i]=0;
	   UpBuffer2[i]=0;
      UpBuffer3[i]=0;
      UpBuffer4[i]=0;
      current=ind_buffer1[i];
      prev=ind_buffer1[i+1];
      current1=ind_buffer2[i];
      prev1=ind_buffer2[i+1];
   	
   
	  
      if((current>prev)&&(current1>prev1) && (current>0) && (current1>0)) trend=2;
      if((current>prev)&&(current1>prev1) && ((current<0) || (current1<0))) trend=1;
      if((current<prev)&&(current1>prev1)) trend=1;
      if((current<prev)&&(current1<prev1)&& (current<0) && (current1<0)) trend=-2;
      if((current<prev)&&(current1<prev1) && ((current>0) || (current1>0))) trend=-1;
      if((current>prev)&&(current1<prev1)) trend=-1;
      
      if(trend==2)
        {
         UpBuffer1[i]=1;
	      UpBuffer2[i]=0;
         UpBuffer3[i]=0;
         UpBuffer4[i]=0;
        }
      if(trend==1)
        {
         UpBuffer1[i]=0;
	      UpBuffer2[i]=1;
         UpBuffer3[i]=0;
         UpBuffer4[i]=0;
        }
      if(trend==-1)
        {
         UpBuffer1[i]=0;
	      UpBuffer2[i]=0;
         UpBuffer3[i]=1;
         UpBuffer4[i]=0;
         
        }
      if(trend==-2)
        {
         UpBuffer1[i]=0;
	      UpBuffer2[i]=0;
         UpBuffer3[i]=0;
         UpBuffer4[i]=1;
         
        }
	  
	  }
   
      
//---- done
   return(0);
  }
//+------------------------------------------------------------------+

