//+------------------------------------------------------------------+
//|                                                     Faux_VIX.mq4 |
//|                            Copyright  2007, Matthew Ebersviller |
//|                                                                  |
//+------------------------------------------------------------------+

/**********************************************************************
* This is a Synthetic VIX indicator as described in the December 2007 *
* issue of "Active Trader" magazine.  The indicator is also named the *
* "Williams VIX Fix" since Larry Williams is credited with the        *
* formula's discovery.                                                *
*                                                                     *
* This indicator was coded by Matthew Ebersviller.                    *
**********************************************************************/


#property copyright "Copyright  2007, Matthew Ebersviller"
#property link      ""

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 DodgerBlue
#property indicator_width1 1

extern int VIX_Period = 22;

double VixBuffer[];


int init() {
   string short_name;
   IndicatorBuffers(1);
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,VixBuffer);
   //SetIndexBuffer(1,TempBuffer);
   short_name="VIX("+VIX_Period+")";
   IndicatorShortName(short_name);
   SetIndexLabel(0,short_name);

   SetIndexDrawBegin(0,VIX_Period);
   
   return(0);
}

int deinit()
  {
   return(0);
  }

int start()
  {
   int i, counted_bars=IndicatorCounted();
   
   if(Bars<=VIX_Period) return(0);
   
   if(counted_bars<1) {
      for(i=1;i<=VIX_Period;i++) {
         VixBuffer[Bars-i]=0.0;
      }
   }

   int limit=Bars-counted_bars;
   if (counted_bars>0) limit++;
   for(i=0; i<limit; i++)
      VixBuffer[i]=VIX(i);
      
   return(0);
  }
//+------------------------------------------------------------------+

double VIX(int shift) {
  double highClose, vix;
  highClose = High[iHighest(NULL,0,MODE_CLOSE,VIX_Period,shift)];
  vix = (highClose - Low[shift]) / highClose * 100;
  return (vix);
}
  