//+------------------------------------------------------------------+
//|                                                          TBS.mq4 |
//|                                      Copyright  2006, Eli Hayun |
//|                                          http://www.elihayun.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Eli Hayun"
#property link      "http://www.elihayun.com"

#define DOWN_TREND -1
#define UP_TREND    1
#define NEUTRAL     0



extern bool use5M  = false;
extern bool use15M  = true;
extern bool use30M  = true;
extern bool use1H  = false;
extern bool use4H  = false;


extern double lots=1.0;
extern int MaxTrades=1;
extern bool ManageMoney = true;
extern int Risk = 2;
extern bool ProfitTrailing = true;  
extern bool UseSound = true;  

extern int StopLoss = 20;
extern int TakeProfit = 100;
extern int TrailingStop = 12; 

extern int timeframe = PERIOD_M15;
  
int TrailingStep = 1;   
string NameFileSound  = "expert.wav";  

int MagicNum = 12344355;

string ss = "";



void deinit() {
   Comment("");
}

//--------------------------------------------------------------------------------------// 

int orderscnt(){
int cnt=0;
   for(int i =0;i<OrdersTotal();i++){
      if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES)){
         if(OrderSymbol()==Symbol() && MagicNum==OrderMagicNumber()){
            cnt++;
         }
      }
   }
   return(cnt);
}

//--------------------------------------------------------------------------------------// 

int start(){

   
   for (int i=0; i<OrdersTotal(); i++) {
       if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
         TrailingPositions();
      }
   }

   if(orderscnt()<MaxTrades){
      if(ManageMoney==true) lots = LotSize();
      if (MathMod(Minute(),Period()) >= 0.5*Period()) return(0);
      CheckOpen();
   }   
}

//--------------------------------------------------------------------------------------// 

void CheckOpen(){
 
  bool Buy = false, Sell=false;

   Buy  = CheckBuySell(OP_BUY);
   Sell = CheckBuySell(OP_SELL);

  
   double TP,SL;
//--------------------------------------------------------------------------------------// 
   if (Buy){
      if(StopLoss==0){SL=0;}else{SL=Ask-StopLoss*Point;}
      if(TakeProfit==0){TP=0;}else{TP=Ask+TakeProfit*Point;}
      OrderSend(Symbol(),OP_BUY,lots,Ask,1,SL,TP,"TBS "+Period(),MagicNum,0,LawnGreen); 
      //Print(ss);
   }
   if (Sell){
      if(StopLoss==0){SL=0;}else{SL=Bid+StopLoss*Point;}
      if(TakeProfit==0){TP=0;}else{TP=Bid-TakeProfit*Point;}
      OrderSend(Symbol(),OP_SELL,lots,Bid,1,SL,TP,"TBS "+Period(),MagicNum,0,HotPink); 
      //Print(ss);
   }
   ss = "";
}
//--------------------------------------------------------------------------------------// 
double LotSize(){
   double lotMM = MathCeil(AccountFreeMargin() * Risk / 1000)/10;  
   if (lotMM < 0.1) lotMM = lots;
   if (lotMM > 1.0) lotMM = MathCeil(lotMM);
   if  (lotMM > 50) lotMM = 50;
   return (lotMM);
} 
//--------------------------------------------------------------------------------------// 
void TrailingPositions() {
  double pBid, pAsk, pp;

  pp = MarketInfo(OrderSymbol(), MODE_POINT);
  if (OrderMagicNumber() != MagicNum)
   return;
  
  if (OrderType()==OP_BUY) 
  {
    pBid = MarketInfo(OrderSymbol(), MODE_BID);
    if (!ProfitTrailing || (pBid-OrderOpenPrice())>TrailingStop*pp) 
    {
      if (OrderStopLoss()<pBid-(TrailingStop+TrailingStep-1)*pp) 
      {
        ModifyStopLoss(pBid-TrailingStop*pp);
        return;
      }
    }
  }
  if (OrderType()==OP_SELL) 
  {
    pAsk = MarketInfo(OrderSymbol(), MODE_ASK);
    if (!ProfitTrailing || OrderOpenPrice()-pAsk>TrailingStop*pp) 
    {
      if (OrderStopLoss()>pAsk+(TrailingStop+TrailingStep-1)*pp || OrderStopLoss()==0) 
      {
        ModifyStopLoss(pAsk+TrailingStop*pp);
        return;
      }
    }
  }
}
//--------------------------------------------------------------------------------------// 
void ModifyStopLoss(double ldStopLoss) {
  bool fm;

  if (OrderMagicNumber() != MagicNum)
   return;
  fm=OrderModify(OrderTicket(),OrderOpenPrice(),ldStopLoss,OrderTakeProfit(),0,Yellow);
  if (fm && UseSound) PlaySound(NameFileSound);
}
//--------------------------------------------------------------------------------------// 

bool NewBar()
{

   static datetime dt = 0;
   if (iTime(NULL,timeframe, 0) != dt)
   {
      dt = iTime(NULL,timeframe, 0);
      //Print(TimeToStr(dt),"  ");
      return(true);
   }
   return(false);
}

void DrawLine(color clr)
{
   static int ix = 1;
   ObjectCreate("ln"+ix, OBJ_VLINE, 0, iTime(NULL, timeframe, 0), Ask);
   ObjectSet("ln"+ix, OBJPROP_COLOR, clr);
   ix++;
   
}

// add logic here 
// CheckBuySell will check if it is safe to buy or safe to sell according to op parameter
// op : OP_BUY or OP_SELL
bool CheckBuySell(int op)
{
   int iTrend = HitEdge();
   if ( (iTrend == UP_TREND) && (op == OP_BUY) )
   {
      return(true);
   }
   
   if ((iTrend == DOWN_TREND) && (op == OP_SELL))
   {
      return(true);
   }
   return(false);
}


int HitEdge()
{
   int retVal = NEUTRAL;
   int period = 34;
   
   double avg;
   int limit = 20;
   
   double upper[30], lower[30];
   int TF = 5;   
   int up = 0, down = 0;
   int tff[] = {5,15,30,60,240};  // timeframes
   int tlr[] = {4,4,6,10,15};     // tollerance in points
   bool bUse[] = {false, false, false, false, false};
   
   int iNum = 0;
   
   if (use5M)  { bUse[0] = true; iNum++; }
   if (use15M) { bUse[1] = true; iNum++; }
   if (use30M) { bUse[2] = true; iNum++; }
   if (use1H)  { bUse[3] = true; iNum++; }
   if (use4H)  { bUse[4] = true; iNum++; }
   
   
   for (int tf = 0; tf<5; tf++)
   {
      TF = tff[tf];
      if (bUse[tf])
      {
         for(int x=0; x<limit; x++) {
            double middle2= iMA(NULL, 0, period, 0, MODE_SMA, PRICE_TYPICAL, x);// only used to calculate outer bands

            avg  = findAvg(TF, period, x);
            upper[x] = middle2 + (3.5*avg);
            lower[x] = middle2 - (3.5*avg);
         }
      
         int p = (Ask - upper[1]) / Point;
         if ((p > 0) && (p < tlr[tf]))
         {
            down++;
         }
         p = (lower[1] - Ask) / Point;
         if ((p > 0) && (p < tlr[tf]))
         {
            up++;
         }
      }
   }
   
   if (up == iNum)
   {
      retVal = UP_TREND;
   }
   if (down == iNum)
   {
      retVal = DOWN_TREND;
   }
   return(retVal);
}

double findAvg(int TF, int period, int shift) {
   double sum=0;
   for (int x=shift;x<(shift+period);x++) {     
      sum += iHigh(NULL, TF,x)-iLow(NULL, TF,x);
   }
   sum = sum/period;
   return (sum);
}

   
