//+------------------------------------------------------------------+
//|                                                          TRD.mq4 |
//|                                                          by Raff |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, raff1410@o2.pl"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Aqua
#property indicator_level1 1
//---- indicator parameters
extern int MA_Period=20;
extern int MA_Method=0;
//---- indicator buffers
double ExtMapBuffer[];
//----
int ExtCountedBars=0;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   int    draw_begin;
   string short_name;
//---- drawing settings
   SetIndexStyle(0,DRAW_LINE);
// SetIndexShift(0,MA_Shift);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
   if(MA_Period<2) MA_Period=13;
   draw_begin=MA_Period-1;
//---- indicator short name
   switch(MA_Method)
     {
      case 1 : short_name="Trend deviation | EMA(";  draw_begin=0; break;
      case 2 : short_name="Trend deviation | SMMA("; break;
      case 3 : short_name="Trend deviation | LWMA("; break;
      default :
         MA_Method=0;
         short_name="Trend deviation | SMA(";
     }
   IndicatorShortName(short_name+MA_Period+")");
   SetIndexDrawBegin(0,draw_begin);
//---- indicator buffers mapping
   SetIndexBuffer(0,ExtMapBuffer);
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| TRD - Trend Deviation                                            |
//+------------------------------------------------------------------+
int start()
  {
   if(Bars<=MA_Period) return(0);
   ExtCountedBars=IndicatorCounted();
//---- check for possible errors
   if (ExtCountedBars<0) return(-1);
//---- last counted bar will be recounted
   if (ExtCountedBars>0) ExtCountedBars--;
//----
   int i,pos=Bars-ExtCountedBars-1;
//---- initial accumulation
   if(pos<MA_Period) pos=MA_Period;
//---- main calculation loop
   while(pos>=0)
     {
      ExtMapBuffer[pos]=Close[pos]/iMA(NULL,0,MA_Period,0,MA_Method,0,0);
 	   pos--;
     }
//---- done
   return(0);
  }

