#include <stdlib.mqh>
//+------------------------------------------------------------------+
//|                                                  TSatr_NRTR2.mq4 |
//|                                                                  |
//|                                                                  |
//|                                        Converted by Mql2Mq4 v1.0 |
//|                                            http://yousky.free.fr |
//|                                    Copyright  2006, Yousky Soft |
//+------------------------------------------------------------------+

#property copyright " OlegVS&Aborigen"
#property link      " olegvs2003@yahoo.com"


//+------------------------------------------------------------------+
//| Common External variables                                        |
//+------------------------------------------------------------------+
extern double Lots = 1.00;
extern double StopLoss = 0.00;
extern double TakeProfit = 0.00;
extern double TrailingStop = 0.00;

//+------------------------------------------------------------------+
//| External variables                                               |
//+------------------------------------------------------------------+
extern double Patr = 9;
extern double Prange = 5;
extern double Kstop = 1.5;
extern double kts = 2;
extern double Vts = 2;

//+------------------------------------------------------------------+
//| Special Convertion Functions                                     |
//+------------------------------------------------------------------+

int LastTradeTime;

bool MOrderModify( int ticket, double price, double stoploss, double takeprofit, datetime expiration, color arrow_color=CLR_NONE)
{
  LastTradeTime = CurTime();
  price = MathRound(price*10000)/10000;
  stoploss = MathRound(stoploss*10000)/10000;
  takeprofit = MathRound(takeprofit*10000)/10000;
  return ( OrderModify( ticket, price, stoploss, takeprofit, expiration, arrow_color) );
}

int OrderValueTicket(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderTicket());
}

int OrderValueType(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderType());
}

double OrderValueOpenPrice(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderOpenPrice());
}

double OrderValueStopLoss(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderStopLoss());
}

double OrderValueTakeProfit(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderTakeProfit());
}

string OrderValueSymbol(int index)
{
  OrderSelect(index, SELECT_BY_POS);
  return(OrderSymbol());
}

//+------------------------------------------------------------------+
//| End                                                              |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Initialization                                                   |
//+------------------------------------------------------------------+

int init()
{
   return(0);
}
int start()
{
//+------------------------------------------------------------------+
//| Local variables                                                  |
//+------------------------------------------------------------------+
int cnt = 0;
double mode = 0;
double ValATR = 0;
double hi = 0;
double lo = 0;
double SL = 0;
double TS = 0;
double prevBars = 0;
int I = 0;

/*[[
	Name := TSatr_NRTR
	Author := OlegVS&Aborigen
	Link := olegvs2003@yahoo.com
	Lots := 1.00
	Stop Loss := 0
	Take Profit := 0
	Trailing Stop := 0
]]*/
 

 
//------------------------------------------------------- 
if( prevBars != Bars ) 
 {
  ValATR=0; 
  for(I=1;I<=Patr ;I++){ 
   if( I <= Patr ) ValATR += High[I]-Low[I];
   
  } 
  ValATR = NormalizeDouble(ValATR / Patr,4); 
     
  hi=High[Highest(MODE_HIGH,Prange,Prange)]; 
  lo=Low[Lowest(NULL, 0, MODE_LOW,Prange,Prange)];   
  
  if( Vts == 1 ) TS=kts*ValATR;
                SL=Kstop*ValATR; 
  if( Vts == 2 ) TS=(hi-lo);
                SL=Kstop*(hi-lo);
  prevBars = Bars;
  }
  if( Vts<1 || Vts>2 ) return(0);

//------------------------------------------------------- 

for(cnt=1;cnt<=OrdersTotal() ;cnt++){ 

mode=OrderValueType(cnt); 

//First Stop--------------------------------- 
if( mode == OP_BUY && 
OrderValueSymbol(cnt) == Symbol() && 
OrderValueStopLoss(cnt) == 0 ) { 
MOrderModify(OrderValueTicket(cnt),OrderValueOpenPrice(cnt),Low-SL,OrderValueTakeProfit(cnt),0,Aqua); 
return(0); } 

if( mode == OP_SELL && 
OrderValueSymbol(cnt) == Symbol() && 
OrderValueStopLoss(cnt) == 0 ) { 
MOrderModify(OrderValueTicket(cnt),OrderValueOpenPrice(cnt),High+SL,OrderValueTakeProfit(cnt),0,Magenta); 
return(0); } 


//Main Trailing------------------------------- 
if( mode == OP_BUY && 
OrderValueSymbol(cnt) == Symbol() && 
High-OrderValueOpenPrice(cnt)>TS && 
(OrderValueStopLoss(cnt)<High-TS || OrderValueStopLoss(cnt) == 0 ) ) { 
MOrderModify(OrderValueTicket(cnt),OrderValueOpenPrice(cnt),High-TS,OrderValueTakeProfit(cnt),0,Aqua); 
return(0); } 

if( mode == OP_SELL && 
OrderValueSymbol(cnt) == Symbol() && 
OrderValueOpenPrice(cnt)-Low>TS && 
(OrderValueStopLoss(cnt)>Low+TS || OrderValueStopLoss(cnt) == 0 ) ) { 
MOrderModify(OrderValueTicket(cnt),OrderValueOpenPrice(cnt),Low+TS,OrderValueTakeProfit(cnt),0,Magenta); 
return(0); } 


} 
Comment("Versia: ",Vts,"'#10'",
        "Per_ATR: ",Patr,"'#10'",
        "Per_Range: ",Prange,"'#10'",
        "Range: ",(hi-lo),"'#10'",
        "ATR: ",ValATR,"'#10'",
        "SL: ",SL,"'#10'",
        "TS: ",TS);


  return(0);
}