//+------------------------------------------------------------------+
//|                                            TtfSignalCombined.mq4 |
//|                                     Copyright  2005, Nick Bilak |
//|                                              corrected by Modest |
//|          combined TTF and TTFSignal, minor corrections by Mladen |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, Nick Bilak"
#property link      ""

#property indicator_separate_window
#property indicator_buffers 4
#property indicator_color1 LightSeaGreen
#property indicator_color2 DimGray
#property indicator_color3 Lime
#property indicator_color4 Red
#property indicator_width3 3
#property indicator_width4 3
#property indicator_level1 0.0
#property indicator_levelcolor DimGray

//---- input parameters
//
//
//
//

extern int    TTFbars    =  15;
extern int    TopLine    =  75;
extern int    BottomLine = -75;
extern int    t3_period  =   3;
extern double b          = 0.7;

//---- buffers
//
//
//
//

double MainBuffer[];
double SignalBufferUp[];
double SignalBufferDn[];
double SignalBuffer[];

//----
//
//
//
//
int    draw_begin;
double r;
double b2,b3;
double c1,c2,c3,c4;
double w1,w2;
double e1,e2,e3,e4,e5,e6;

//
//
//
//
//

double  HighestHighRecent;
double  HighestHighOlder;
double  LowestLowRecent;
double  LowestLowOlder;
double  BuyPower;
double  SellPower;
double  TTF;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   SetIndexBuffer(0, MainBuffer);
   SetIndexBuffer(1, SignalBuffer);
   SetIndexBuffer(2, SignalBufferUp);
   SetIndexBuffer(3, SignalBufferDn);

   SetIndexLabel(0,"TTF");
   SetIndexLabel(1,"Signal");
   SetIndexLabel(1,"SignalUp");
   SetIndexLabel(1,"SignalDown");

   //
   //
   //
   //
   //

   draw_begin=TTFbars*2+1;
      SetIndexDrawBegin(0,draw_begin);
      SetIndexDrawBegin(1,draw_begin);
      SetIndexDrawBegin(2,draw_begin);
      SetIndexDrawBegin(3,draw_begin);
   IndicatorShortName("TTF signal combined ("+TTFbars+")");

   //
   //
   //
   //
   //
      
   b2=b*b;
   b3=b2*b;
   c1=-b3;
   c2=(3*(b2+b3));
   c3=-3*(2*b2+b+b3);
   c4=(1+3*b+b3+3*b2);

   r=t3_period;

   if (r<1) r=1;
   r = 1 + 0.5*(r-1);
   w1 = 2 / (r + 1);
   w2 = 1 - w1;
   
   //
   //
   //
   //
   //----

   return(0);
}
//+------------------------------------------------------------------+
//| ttf                                            |
//+------------------------------------------------------------------+
int start()
{
   int    counted_bars=IndicatorCounted();
   int    i;
   
   //
   //
   //
   //
   //
   
   if( Bars<=draw_begin) return( 0);
   if (counted_bars<0)   return(-1);
   if (counted_bars<1)
      for(i=1;i<=draw_begin;i++)
         {
            MainBuffer[Bars-i]=0;         
            SignalBufferUp[Bars-i]=0;
            SignalBufferDn[Bars-i]=0;
            SignalBuffer[Bars-i]=0;
         }          

   //
   //
   //
   //
   //
   
   i=Bars-draw_begin;
   if(counted_bars>draw_begin) i=Bars-counted_bars-1;
   while(i>=0)
   {
      HighestHighRecent= High[iHighest(NULL,0,MODE_HIGH,TTFbars,i)];
      HighestHighOlder = High[iHighest(NULL,0,MODE_HIGH,TTFbars,i+TTFbars)];
      LowestLowRecent  = Low[iLowest(NULL,0,MODE_LOW,TTFbars,i)];
      LowestLowOlder   = Low[iLowest(NULL,0,MODE_LOW,TTFbars,i+TTFbars)];
      BuyPower         = HighestHighRecent-LowestLowOlder;
      SellPower        = HighestHighOlder -LowestLowRecent;
  
      //
      //
      //
      //
      //
      
      TTF=(BuyPower-SellPower)/(0.5*(BuyPower+SellPower))*100;

      e1 = w1*TTF + w2*e1;
      e2 = w1*e1  + w2*e2;
      e3 = w1*e2  + w2*e3;
      e4 = w1*e3  + w2*e4;
      e5 = w1*e4  + w2*e5;
      e6 = w1*e5  + w2*e6;

      TTF = c1*e6 + c2*e5 + c3*e4 + c4*e3;

      MainBuffer[i]=TTF;
      i--;
   }

   //
   //
   //
   //
   //
   
   if(counted_bars>0) counted_bars--;
   int limit=Bars-counted_bars;
   for(i=0; i<limit; i++)
   {
      if (MainBuffer[i]>=0) 
               SignalBuffer[i]=TopLine;
      else     SignalBuffer[i]=BottomLine;
      if (MainBuffer[i]>=TopLine) 
               {SignalBufferUp[i]=TopLine;SignalBufferDn[i]=EMPTY_VALUE ;}
      if (MainBuffer[i]<=BottomLine) 
               {SignalBufferDn[i]=BottomLine;SignalBufferUp[i]=EMPTY_VALUE; }
      if (MainBuffer[i]>BottomLine && MainBuffer[i]<TopLine) 
               {SignalBufferUp[i]=EMPTY_VALUE; SignalBufferDn[i]=EMPTY_VALUE;}
   }
   return(0);
}
//+------------------------------------------------------------------+

